/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;
import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.cards.CreateCardRequest;
import net.joelinn.stripe.request.cards.UpdateCardRequest;
import net.joelinn.stripe.response.DeleteResponse;
import net.joelinn.stripe.response.cards.CardResponse;
import net.joelinn.stripe.response.cards.ListCardsResponse;

public class Cards
extends AbstractApi {
    public Cards(Client client) {
        super(client);
    }

    public CardResponse createCard(String customerId, String token) {
        MultivaluedMapImpl request = new MultivaluedMapImpl();
        request.add((Object)"card", (Object)token);
        return this.client.post(this.buildUrl(customerId), CardResponse.class, (MultivaluedMap<String, String>)request);
    }

    public CardResponse createCard(String customerId, CreateCardRequest request) {
        return this.client.post(this.buildUrl(customerId), CardResponse.class, request.toRequest());
    }

    public CardResponse updateCard(String customerId, String cardId, UpdateCardRequest request) {
        return this.client.post(this.buildUrl(customerId, cardId), CardResponse.class, request.toRequest());
    }

    public CardResponse getCard(String customerId, String cardId) {
        return this.client.get(this.buildUrl(customerId, cardId), CardResponse.class);
    }

    public DeleteResponse deleteCard(String customerId, String cardId) {
        return this.client.delete(this.buildUrl(customerId, cardId), DeleteResponse.class);
    }

    public ListCardsResponse listCards(String customerId) {
        return this.listCards(customerId, null);
    }

    public ListCardsResponse listCards(String customerId, Integer limit) {
        MultivaluedMapImpl request = new MultivaluedMapImpl();
        if (limit != null) {
            request.add((Object)"limit", (Object)String.valueOf(limit));
        }
        return this.client.get(this.buildUrl(customerId), ListCardsResponse.class, null, (MultivaluedMap<String, String>)request);
    }

    protected String buildUrl(String customerId) {
        return this.buildUrl(customerId, null);
    }

    protected String buildUrl(String customerId, String cardId) {
        String url = "customers/" + customerId + "/cards";
        if (cardId != null) {
            url = url + "/" + cardId;
        }
        return url;
    }
}

