/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.RequestUtil;
import net.joelinn.stripe.request.charges.CreateChargeRequest;
import net.joelinn.stripe.response.charges.ChargeResponse;
import net.joelinn.stripe.response.charges.ListChargesResponse;

public class Charges
extends AbstractApi {
    public Charges(Client client) {
        super(client);
    }

    public ChargeResponse createCharge(CreateChargeRequest request) {
        MultivaluedMap<String, String> body = request.toRequest();
        return this.client.post(this.buildUrl(), ChargeResponse.class, body);
    }

    public ChargeResponse getCharge(String chargeId) {
        return this.client.get(this.buildUrl(chargeId), ChargeResponse.class);
    }

    public ChargeResponse updateCharge(String chargeId, String description, Map<String, Object> metadata) {
        MultivaluedMapImpl request = new MultivaluedMapImpl();
        if (description != null) {
            request.add("description", description);
        }
        if (metadata != null) {
            request.putAll(RequestUtil.mapToRequest(metadata, "metadata"));
        }
        return this.client.post(this.buildUrl(chargeId), ChargeResponse.class, (MultivaluedMap<String, String>)request);
    }

    public ChargeResponse refundCharge(String chargeId) {
        return this.refundCharge(chargeId, null, null);
    }

    public ChargeResponse refundCharge(String chargeId, Integer amount, Integer refundApplicationFee) {
        MultivaluedMapImpl request = new MultivaluedMapImpl();
        if (amount != null) {
            request.add("amount", String.valueOf(amount));
        }
        if (refundApplicationFee != null) {
            request.add("refund_application_fee", String.valueOf(refundApplicationFee));
        }
        return this.client.post(this.buildUrl(chargeId) + "/refund", ChargeResponse.class, (MultivaluedMap<String, String>)request);
    }

    public ChargeResponse captureCharge(String chargeId) {
        return this.captureCharge(chargeId, null, null);
    }

    public ChargeResponse captureCharge(String chargeId, Integer amount, Integer applicationFee) {
        MultivaluedMapImpl request = new MultivaluedMapImpl();
        if (amount != null) {
            request.add("amount", String.valueOf(amount));
        }
        if (applicationFee != null) {
            request.add("application_fee", String.valueOf(applicationFee));
        }
        return this.client.post(this.buildUrl(chargeId) + "/capture", ChargeResponse.class, (MultivaluedMap<String, String>)request);
    }

    public ListChargesResponse listCharges(Integer limit) {
        MultivaluedMapImpl request = new MultivaluedMapImpl();
        if (limit != null) {
            request.add("limit", String.valueOf(limit));
        }
        return this.client.get(this.buildUrl(), ListChargesResponse.class, null, (MultivaluedMap<String, String>)request);
    }

    protected String buildUrl() {
        return this.buildUrl(null);
    }

    protected String buildUrl(String chargeId) {
        String url = "charges";
        if (chargeId != null) {
            url = url + "/" + chargeId;
        }
        return url;
    }
}

