/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.coupons.CreateCouponRequest;
import net.joelinn.stripe.response.DeleteResponse;
import net.joelinn.stripe.response.coupons.CouponResponse;

public class Coupons
extends AbstractApi {
    public Coupons(Client client) {
        super(client);
    }

    public CouponResponse createCoupon(CreateCouponRequest request) {
        return this.client.post(this.buildUrl(), CouponResponse.class, request.toRequest());
    }

    public CouponResponse getCoupon(String couponId) {
        return this.client.get(this.buildUrl(couponId), CouponResponse.class);
    }

    public DeleteResponse deleteCoupon(String couponId) {
        return this.client.delete(this.buildUrl(couponId), DeleteResponse.class);
    }

    protected String buildUrl() {
        return this.buildUrl(null);
    }

    protected String buildUrl(String couponId) {
        String url = "coupons";
        if (couponId != null) {
            url = url + "/" + couponId;
        }
        return url;
    }
}

