/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import javax.ws.rs.core.MultivaluedMap;
import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.customers.CreateCustomerRequest;
import net.joelinn.stripe.request.customers.UpdateCustomerRequest;
import net.joelinn.stripe.response.DeleteResponse;
import net.joelinn.stripe.response.customers.CustomerResponse;
import net.joelinn.stripe.response.customers.ListCustomersResponse;

public class Customers
extends AbstractApi {
    public Customers(Client client) {
        super(client);
    }

    public CustomerResponse createCustomer() {
        return this.client.post("customers", CustomerResponse.class);
    }

    public CustomerResponse createCustomer(CreateCustomerRequest request) {
        return this.client.post("customers", CustomerResponse.class, request.toRequest());
    }

    public CustomerResponse getCustomer(String customerId) {
        return this.client.get(this.buildUrl(customerId), CustomerResponse.class);
    }

    public CustomerResponse updateCustomer(String customerId, UpdateCustomerRequest request) {
        return this.client.post(this.buildUrl(customerId), CustomerResponse.class, request.toRequest());
    }

    public DeleteResponse deleteCustomer(String customerId) {
        return this.client.delete(this.buildUrl(customerId), DeleteResponse.class);
    }

    public ListCustomersResponse listCustomers() {
        return this.client.get("customers", ListCustomersResponse.class);
    }

    public ListCustomersResponse listCustomers(MultivaluedMap<String, String> queryParams) {
        return this.client.get("customers", ListCustomersResponse.class, queryParams);
    }

    protected String buildUrl(String customerId) {
        return "customers/" + customerId;
    }
}

