/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.invoiceitems.CreateInvoiceItemRequest;
import net.joelinn.stripe.request.invoiceitems.ListInvoiceItemsRequest;
import net.joelinn.stripe.request.invoiceitems.UpdateInvoiceItemRequest;
import net.joelinn.stripe.response.DeleteResponse;
import net.joelinn.stripe.response.invoiceitems.InvoiceItemResponse;
import net.joelinn.stripe.response.invoiceitems.ListInvoiceItemsResponse;

public class InvoiceItems
extends AbstractApi {
    public InvoiceItems(Client client) {
        super(client);
    }

    public InvoiceItemResponse createInvoiceItem(CreateInvoiceItemRequest request) {
        return this.client.post(this.buildUrl(), InvoiceItemResponse.class, request.toRequest());
    }

    public InvoiceItemResponse getInvoiceItem(String invoiceItemId) {
        return this.client.get(this.buildUrl(invoiceItemId), InvoiceItemResponse.class);
    }

    public InvoiceItemResponse updateInvoiceItem(String invoiceItemId, UpdateInvoiceItemRequest request) {
        return this.client.post(this.buildUrl(invoiceItemId), InvoiceItemResponse.class, request.toRequest());
    }

    public DeleteResponse deleteInvoiceItem(String invoiceItemId) {
        return this.client.delete(this.buildUrl(invoiceItemId), DeleteResponse.class);
    }

    public ListInvoiceItemsResponse listInvoiceItems(ListInvoiceItemsRequest request) {
        return this.client.get(this.buildUrl(), ListInvoiceItemsResponse.class, null, request.toRequest());
    }

    protected String buildUrl() {
        return this.buildUrl(null);
    }

    protected String buildUrl(String invoiceItemId) {
        String url = "invoiceitems";
        if (invoiceItemId != null) {
            url = url + "/" + invoiceItemId;
        }
        return url;
    }
}

