/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;
import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.invoices.CreateInvoiceRequest;
import net.joelinn.stripe.request.invoices.ListInvoiceLineItemsRequest;
import net.joelinn.stripe.request.invoices.ListInvoicesRequest;
import net.joelinn.stripe.request.invoices.UpdateInvoiceRequest;
import net.joelinn.stripe.response.invoices.InvoiceResponse;
import net.joelinn.stripe.response.invoices.ListInvoicesResponse;
import net.joelinn.stripe.response.invoices.ListLineItemsResponse;

public class Invoices
extends AbstractApi {
    public Invoices(Client client) {
        super(client);
    }

    public InvoiceResponse createInvoice(CreateInvoiceRequest request) {
        return this.client.post(this.buildUrl(), InvoiceResponse.class, request.toRequest());
    }

    public InvoiceResponse getInvoice(String invoiceId) {
        return this.client.get(this.buildUrl(invoiceId), InvoiceResponse.class);
    }

    public InvoiceResponse updateInvoice(String invoiceId, UpdateInvoiceRequest request) {
        return this.client.post(this.buildUrl(invoiceId), InvoiceResponse.class, request.toRequest());
    }

    public InvoiceResponse payInvoice(String invoiceId) {
        return this.client.post(this.buildUrl(invoiceId) + "/pay", InvoiceResponse.class);
    }

    public ListInvoicesResponse listInvoices(ListInvoicesRequest request) {
        return this.client.get(this.buildUrl(), ListInvoicesResponse.class, null, request.toRequest());
    }

    public ListLineItemsResponse listInvoiceLineItems(String invoiceId, ListInvoiceLineItemsRequest request) {
        return this.client.get(this.buildUrl(invoiceId) + "/lines", ListLineItemsResponse.class, null, request.toRequest());
    }

    public InvoiceResponse getUpcomingInvoice(String customerId) {
        return this.getUpcomingInvoice(customerId, null);
    }

    public InvoiceResponse getUpcomingInvoice(String customerId, String subscriptionId) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("customer", customerId);
        if (subscriptionId != null) {
            params.add("subscription", subscriptionId);
        }
        return this.client.get("invoices/upcoming", InvoiceResponse.class, null, (MultivaluedMap<String, String>)params);
    }

    protected String buildUrl() {
        return this.buildUrl(null);
    }

    protected String buildUrl(String invoiceId) {
        String url = "invoices";
        if (invoiceId != null) {
            url = url + "/" + invoiceId;
        }
        return url;
    }
}

