/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.plans.CreatePlanRequest;
import net.joelinn.stripe.request.plans.ListPlansRequest;
import net.joelinn.stripe.request.plans.UpdatePlanRequest;
import net.joelinn.stripe.response.DeleteResponse;
import net.joelinn.stripe.response.plans.ListPlansResponse;
import net.joelinn.stripe.response.plans.PlanResponse;

public class Plans
extends AbstractApi {
    public Plans(Client client) {
        super(client);
    }

    public PlanResponse createPlan(CreatePlanRequest request) {
        return this.client.post(this.buildUrl(), PlanResponse.class, request.toRequest());
    }

    public PlanResponse getPlan(String planId) {
        return this.client.get(this.buildUrl(planId), PlanResponse.class);
    }

    public PlanResponse updatePlan(String planId, UpdatePlanRequest request) {
        return this.client.post(this.buildUrl(planId), PlanResponse.class, request.toRequest());
    }

    public DeleteResponse deletePlan(String planId) {
        return this.client.delete(this.buildUrl(planId), DeleteResponse.class);
    }

    public ListPlansResponse listPlans(ListPlansRequest request) {
        return this.client.get(this.buildUrl(), ListPlansResponse.class, null, request.toRequest());
    }

    protected String buildUrl() {
        return this.buildUrl(null);
    }

    protected String buildUrl(String planId) {
        String url = "plans";
        if (planId != null) {
            url = url + "/" + planId;
        }
        return url;
    }
}

