/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.recipients.CreateRecipientRequest;
import net.joelinn.stripe.request.recipients.ListRecipientsRequest;
import net.joelinn.stripe.request.recipients.UpdateRecipientRequest;
import net.joelinn.stripe.response.DeleteResponse;
import net.joelinn.stripe.response.recipients.ListRecipientsResponse;
import net.joelinn.stripe.response.recipients.RecipientResponse;

public class Recipients
extends AbstractApi {
    public Recipients(Client client) {
        super(client);
    }

    public RecipientResponse createRecipient(CreateRecipientRequest request) {
        return this.client.post(this.buildUrl(), RecipientResponse.class, request.toRequest());
    }

    public RecipientResponse getRecipient(String recipientId) {
        return this.client.get(this.buildUrl(recipientId), RecipientResponse.class);
    }

    public RecipientResponse updateRecipient(String recipientId, UpdateRecipientRequest request) {
        return this.client.post(this.buildUrl(recipientId), RecipientResponse.class, request.toRequest());
    }

    public DeleteResponse deleteRecipient(String recipientId) {
        return this.client.delete(this.buildUrl(recipientId), DeleteResponse.class);
    }

    public ListRecipientsResponse listRecipients(ListRecipientsRequest request) {
        return this.client.get(this.buildUrl(), ListRecipientsResponse.class, null, request.toRequest());
    }

    protected String buildUrl() {
        return this.buildUrl(null);
    }

    protected String buildUrl(String recipientId) {
        String url = "recipients";
        if (recipientId != null) {
            url = url + "/" + recipientId;
        }
        return url;
    }
}

