/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.ListRequest;
import net.joelinn.stripe.request.RequestUtil;
import net.joelinn.stripe.request.refunds.CreateRefundRequest;
import net.joelinn.stripe.response.refunds.ListRefundsResponse;
import net.joelinn.stripe.response.refunds.RefundResponse;

public class Refunds
extends AbstractApi {
    public Refunds(Client client) {
        super(client);
    }

    public RefundResponse createRefund(String chargeId) {
        return this.client.post(this.buildUrl(chargeId), RefundResponse.class);
    }

    public RefundResponse createRefund(String chargeId, CreateRefundRequest request) {
        return this.client.post(this.buildUrl(chargeId), RefundResponse.class, request.toRequest());
    }

    public RefundResponse getRefund(String chargeId, String refundId) {
        return this.client.get(this.buildUrl(chargeId, refundId), RefundResponse.class);
    }

    public RefundResponse updateRefund(String chargeId, String refundId, Map<String, Object> metadata) {
        MultivaluedMapImpl request = new MultivaluedMapImpl();
        if (metadata != null) {
            request.putAll(RequestUtil.mapToRequest(metadata, "metadata"));
        }
        return this.client.post(this.buildUrl(chargeId, refundId), RefundResponse.class, (MultivaluedMap<String, String>)request);
    }

    public ListRefundsResponse listRefunds(String chargeId, ListRequest listRequest) {
        return this.client.get(this.buildUrl(chargeId), ListRefundsResponse.class, listRequest.toRequest());
    }

    protected String buildUrl(String chargeId) {
        return this.buildUrl(chargeId, null);
    }

    protected String buildUrl(String chargeId, String refundId) {
        String url = "charges/" + chargeId + "/refunds";
        if (refundId != null) {
            url = url + "/" + refundId;
        }
        return url;
    }
}

