/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;
import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.subscriptions.CreateSubscriptionRequest;
import net.joelinn.stripe.request.subscriptions.ListSubscriptionsRequest;
import net.joelinn.stripe.request.subscriptions.UpdateSubscriptionRequest;
import net.joelinn.stripe.response.subscriptions.ListSubscriptionsResponse;
import net.joelinn.stripe.response.subscriptions.SubscriptionResponse;

public class Subscriptions
extends AbstractApi {
    public Subscriptions(Client client) {
        super(client);
    }

    public SubscriptionResponse createSubscription(String customerId, CreateSubscriptionRequest request) {
        return this.client.post(this.buildUrl(customerId), SubscriptionResponse.class, request.toRequest());
    }

    public SubscriptionResponse getSubscription(String customerId, String subscriptionId) {
        return this.client.get(this.buildUrl(customerId, subscriptionId), SubscriptionResponse.class);
    }

    public SubscriptionResponse updateSubscription(String customerId, String subscriptionId, UpdateSubscriptionRequest request) {
        return this.client.post(this.buildUrl(customerId, subscriptionId), SubscriptionResponse.class, request.toRequest());
    }

    public SubscriptionResponse cancelSubscription(String customerId, String subscriptionId) {
        return this.cancelSubscription(customerId, subscriptionId, null);
    }

    public SubscriptionResponse cancelSubscription(String customerId, String subscriptionId, Boolean atPeriodEnd) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (atPeriodEnd != null) {
            params.add("at_period_end", String.valueOf(atPeriodEnd));
        }
        return this.client.delete(this.buildUrl(customerId, subscriptionId), SubscriptionResponse.class, null, (MultivaluedMap<String, String>)params);
    }

    public ListSubscriptionsResponse listSubscriptions(String customerId, ListSubscriptionsRequest request) {
        return this.client.get(this.buildUrl(customerId), ListSubscriptionsResponse.class, null, request.toRequest());
    }

    protected String buildUrl(String customerId) {
        return this.buildUrl(customerId, null);
    }

    protected String buildUrl(String customerId, String subscriptionId) {
        String url = "customers/" + customerId + "/subscriptions";
        if (subscriptionId != null) {
            url = url + "/" + subscriptionId;
        }
        return url;
    }
}

