/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.api;

import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.AbstractApi;
import net.joelinn.stripe.request.transfers.CreateTransferRequest;
import net.joelinn.stripe.request.transfers.ListTransfersRequest;
import net.joelinn.stripe.request.transfers.UpdateTransferRequest;
import net.joelinn.stripe.response.transfers.ListTransfersResponse;
import net.joelinn.stripe.response.transfers.TransferResponse;

public class Transfers
extends AbstractApi {
    public Transfers(Client client) {
        super(client);
    }

    public TransferResponse createTransfer(CreateTransferRequest request) {
        return this.client.post(this.buildUrl(), TransferResponse.class, request.toRequest());
    }

    public TransferResponse getTransfer(String transferId) {
        return this.client.get(this.buildUrl(transferId), TransferResponse.class);
    }

    public TransferResponse updateTransfer(String transferId, UpdateTransferRequest request) {
        return this.client.post(this.buildUrl(transferId), TransferResponse.class, request.toRequest());
    }

    public TransferResponse cancelTransfer(String transferId) {
        return this.client.post(this.buildUrl(transferId) + "/cancel", TransferResponse.class);
    }

    public ListTransfersResponse listTransfers(ListTransfersRequest request) {
        return this.client.get(this.buildUrl(), ListTransfersResponse.class, null, request.toRequest());
    }

    protected String buildUrl() {
        return this.buildUrl(null);
    }

    protected String buildUrl(String transferId) {
        String url = "transfers";
        if (transferId != null) {
            url = url + "/" + transferId;
        }
        return url;
    }
}

