/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.joelinn.stripe.json.StripeModule;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;

public class StripeObjectDeserializer
extends JsonDeserializer<Map<String, Object>> {
    protected static final String OBJECT_KEY = "object";

    public Map<String, Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode object;
        JsonNode jsonNode = jp.readValueAsTree();
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        if (!jsonNode.isObject()) {
            throw new JsonParseException("Object expected.", jp.getCurrentLocation());
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.registerModule((Module)new StripeModule());
        if (jsonNode.has(OBJECT_KEY) && (object = jsonNode.get(OBJECT_KEY)).has(OBJECT_KEY)) {
            String objectType = object.get(OBJECT_KEY).asText();
            try {
                Class responseClass = this.findResponseClass(objectType);
                parsed.put(OBJECT_KEY, mapper.convertValue((Object)object, responseClass));
            }
            catch (IllegalArgumentException e) {
                parsed.put(OBJECT_KEY, mapper.readValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
            catch (ClassNotFoundException e) {
                parsed.put(OBJECT_KEY, mapper.readValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
        }
        Iterator fields = jsonNode.getFields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            JsonNode value = (JsonNode)field.getValue();
            if (((String)field.getKey()).equals(OBJECT_KEY)) continue;
            if (value.isObject()) {
                parsed.put((String)field.getKey(), mapper.readValue(value, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                continue;
            }
            if (!value.isArray()) continue;
            parsed.put((String)field.getKey(), mapper.readValue(value, (TypeReference)new TypeReference<List<Object>>(){}));
        }
        return parsed;
    }

    protected Class findResponseClass(String objectType) throws ClassNotFoundException {
        String className = "net.joelinn.stripe.response." + objectType + "s." + Character.toUpperCase(objectType.charAt(0)) + objectType.substring(1) + "Response";
        return Class.forName(className);
    }
}

