/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe.request;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import net.joelinn.stripe.request.RequestUtil;
import org.codehaus.jackson.map.PropertyNamingStrategy;

public abstract class Request {
    public MultivaluedMap<String, String> toRequest() {
        return this.toRequest(this);
    }

    protected MultivaluedMap<String, String> toRequest(Request request) {
        return this.toRequest(request, null);
    }

    protected MultivaluedMap<String, String> toRequest(Request request, String prefix) {
        MultivaluedMapImpl map = new MultivaluedMapImpl();
        Class<?> cls = request.getClass();
        PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy naming = new PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy();
        while (!cls.equals(Request.class)) {
            for (Field field : cls.getDeclaredFields()) {
                try {
                    Object fieldValue;
                    boolean inaccessible = false;
                    if (!Modifier.isPublic(field.getModifiers())) {
                        field.setAccessible(true);
                        inaccessible = true;
                    }
                    if ((fieldValue = field.get(request)) != null) {
                        String key = naming.translate(field.getName());
                        if (prefix != null) {
                            key = prefix + "[" + key + "]";
                        }
                        if (fieldValue instanceof Map) {
                            map.putAll(RequestUtil.mapToRequest((Map)fieldValue, key));
                        } else if (fieldValue instanceof Request) {
                            map.putAll(this.toRequest((Request)fieldValue, key));
                        } else if (fieldValue instanceof Date) {
                            map.add(key, this.dateToString((Date)fieldValue));
                        } else {
                            map.add(key, String.valueOf(fieldValue));
                        }
                    }
                    if (!inaccessible) continue;
                    field.setAccessible(false);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            cls = cls.getSuperclass();
        }
        return map;
    }

    protected String dateToString(Date date) {
        return String.valueOf(date.getTime() / 1000L);
    }
}

