/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.tool.maven.dependencies;

import java.io.File;
import java.util.Optional;
import net.jonathangiles.tool.maven.dependencies.Main;
import net.jonathangiles.tool.maven.dependencies.misc.Result;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="check")
public class DepCheckerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="check.reporters", defaultValue="")
    private String reporters;
    @Parameter
    private boolean analyseBom;
    @Parameter
    private boolean dependencyManagement;
    @Parameter
    private boolean showAll;
    @Parameter
    private boolean failOnDependencyConflict;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Main main = new Main(){

            protected File[] loadInputs() {
                return new File[]{DepCheckerMojo.this.project.getFile()};
            }
        };
        main.setReporters(this.reporters);
        main.setShowAll(this.showAll);
        main.setAnalyseBom(this.analyseBom);
        main.setDependencyManagement(this.dependencyManagement);
        this.getLog().info((CharSequence)("Hello: " + this.project.getFile()));
        this.getLog().info((CharSequence)("Running with configuration: [ reporters='" + this.reporters + '\'' + ", analyseBom=" + this.analyseBom + ", dependencyManagement=" + this.dependencyManagement + ", showAll=" + this.showAll + ", failOnDependencyConflict=" + this.failOnDependencyConflict + " ]"));
        Optional resultOptional = main.run();
        if (resultOptional.isPresent()) {
            Result result = (Result)resultOptional.get();
            if (this.failOnDependencyConflict && result == Result.DEPENDENCY_VERSION_CONFLICTS) {
                throw new MojoFailureException("Dependency conflicts found. Refer to generated report file for more details.");
            }
        }
    }
}

