/*
 * Decompiled with CFR 0.152.
 */
package net.joshka.junit.json.params;

import java.io.InputStream;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import net.joshka.junit.json.params.JsonFileSource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.util.Preconditions;

public class JsonFileArgumentsProvider
implements AnnotationConsumer<JsonFileSource>,
ArgumentsProvider {
    private final BiFunction<Class, String, InputStream> inputStreamProvider;
    private String[] resources;

    JsonFileArgumentsProvider() {
        this(Class::getResourceAsStream);
    }

    JsonFileArgumentsProvider(BiFunction<Class, String, InputStream> inputStreamProvider) {
        this.inputStreamProvider = inputStreamProvider;
    }

    private static Stream<JsonValue> values(InputStream inputStream) {
        try (JsonReader reader = Json.createReader((InputStream)inputStream);){
            JsonStructure structure = reader.read();
            Stream stream = structure.getValueType() == JsonValue.ValueType.ARRAY ? structure.asJsonArray().stream() : Stream.of(structure);
            return stream;
        }
    }

    public void accept(JsonFileSource jsonFileSource) {
        this.resources = jsonFileSource.resources();
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return Arrays.stream(this.resources).map(resource -> this.openInputStream(context, (String)resource)).flatMap(JsonFileArgumentsProvider::values).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private InputStream openInputStream(ExtensionContext context, String resource) {
        Class testClass = context.getRequiredTestClass();
        InputStream inputStream = this.inputStreamProvider.apply(testClass, resource);
        return (InputStream)Preconditions.notNull((Object)inputStream, () -> "Classpath resource does not exist: " + resource);
    }
}

