/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import java.util.List;
import java.util.Optional;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.LifecycleHook;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
@FunctionalInterface
public interface SkipExecutionHook
extends LifecycleHook<SkipExecutionHook> {
    public SkipResult shouldBeSkipped(LifecycleContext var1);

    @Override
    default public int compareTo(SkipExecutionHook other) {
        return Integer.compare(this.order(), other.order());
    }

    default public int order() {
        return 0;
    }

    default public SkipExecutionHook then(SkipExecutionHook rest) {
        return descriptor -> {
            SkipResult result = this.shouldBeSkipped(descriptor);
            if (result.isSkipped()) {
                return result;
            }
            return rest.shouldBeSkipped(descriptor);
        };
    }

    public static SkipExecutionHook combine(List<SkipExecutionHook> skipExecutionHooks) {
        if (skipExecutionHooks.isEmpty()) {
            return descriptor -> SkipResult.doNotSkip();
        }
        SkipExecutionHook first = skipExecutionHooks.remove(0);
        return first.then(SkipExecutionHook.combine(skipExecutionHooks));
    }

    public static class SkipResult {
        private final boolean skipped;
        private final String reason;

        public static SkipResult skip(String reason) {
            return new SkipResult(true, reason);
        }

        public static SkipResult doNotSkip() {
            return new SkipResult(false, null);
        }

        private SkipResult(boolean skipped, String reason) {
            this.skipped = skipped;
            this.reason = reason == null || reason.isEmpty() ? null : reason;
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public Optional<String> reason() {
            return Optional.ofNullable(this.reason);
        }

        public String toString() {
            String skipString = this.skipped ? "skip" : "do not skip";
            String reasonString = this.reason().map(reason -> ": " + reason).orElse("");
            return String.format("SkipResult(%s%s)", skipString, reasonString);
        }
    }
}

