/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.SizableArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public interface Arbitrary<T> {
    public RandomGenerator<T> generator(int var1);

    default public Optional<ExhaustiveGenerator<T>> exhaustive() {
        return Optional.empty();
    }

    default public Optional<Stream<T>> allValues() {
        return this.exhaustive().map((? super T generator) -> StreamSupport.stream(generator.spliterator(), false));
    }

    @API(status=API.Status.MAINTAINED, since="1.1.2")
    default public void forEachValue(Consumer<? super T> action) {
        if (!this.allValues().isPresent()) {
            throw new AssertionError((Object)("Cannot generate all values of " + this.toString()));
        }
        this.allValues().ifPresent(stream -> stream.forEach(action::accept));
    }

    default public Arbitrary<T> filter(final Predicate<T> filterPredicate) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).filter(filterPredicate);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive() {
                return Arbitrary.this.exhaustive().map((? super T generator) -> generator.filter(filterPredicate));
            }
        };
    }

    default public <U> Arbitrary<U> map(final Function<T, U> mapper) {
        return new Arbitrary<U>(){

            @Override
            public RandomGenerator<U> generator(int genSize) {
                return Arbitrary.this.generator(genSize).map(mapper);
            }

            @Override
            public Optional<ExhaustiveGenerator<U>> exhaustive() {
                return Arbitrary.this.exhaustive().map((? super T generator) -> generator.map(mapper));
            }
        };
    }

    default public <U> Arbitrary<U> flatMap(final Function<T, Arbitrary<U>> mapper) {
        return new Arbitrary<U>(){

            @Override
            public RandomGenerator<U> generator(int genSize) {
                return Arbitrary.this.generator(genSize).flatMap(mapper, genSize);
            }

            @Override
            public Optional<ExhaustiveGenerator<U>> exhaustive() {
                return Arbitrary.this.exhaustive().flatMap((? super T generator) -> ArbitraryFacade.implementation.flatMapExhaustiveGenerator(generator, mapper));
            }
        };
    }

    default public Arbitrary<T> injectNull(final double nullProbability) {
        if (nullProbability <= 0.0) {
            return this;
        }
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).injectNull(nullProbability);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive() {
                return Arbitrary.this.exhaustive().map(ExhaustiveGenerator::injectNull);
            }
        };
    }

    default public Arbitrary<T> unique() {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).unique();
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive() {
                return Arbitrary.this.exhaustive().map(ExhaustiveGenerator::unique);
            }

            @Override
            public SizableArbitrary<List<T>> list() {
                return ArbitraryFacade.implementation.listOfUnique(this);
            }

            @Override
            public <A> SizableArbitrary<A> array(Class<A> arrayClass) {
                return ArbitraryFacade.implementation.arrayOfUnique(this, arrayClass);
            }
        };
    }

    default public Arbitrary<T> withSamples(final T ... samples) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).withSamples(samples);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive() {
                return Arbitrary.this.exhaustive().map((? super T exhaustive) -> exhaustive.withSamples(samples));
            }
        };
    }

    @API(status=API.Status.MAINTAINED, since="1.2.0")
    default public Arbitrary<T> fixGenSize(final int genSize) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int ignoredGenSize) {
                return Arbitrary.this.generator(genSize);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive() {
                return Arbitrary.this.exhaustive();
            }
        };
    }

    default public SizableArbitrary<List<T>> list() {
        return ArbitraryFacade.implementation.list(this);
    }

    default public SizableArbitrary<Set<T>> set() {
        return ArbitraryFacade.implementation.set(this);
    }

    default public SizableArbitrary<Stream<T>> stream() {
        return ArbitraryFacade.implementation.stream(this);
    }

    default public SizableArbitrary<Iterator<T>> iterator() {
        return ArbitraryFacade.implementation.iterator(this);
    }

    default public <A> SizableArbitrary<A> array(Class<A> arrayClass) {
        return ArbitraryFacade.implementation.array(this, arrayClass);
    }

    default public Arbitrary<Optional<T>> optional() {
        return this.injectNull(0.05).map(Optional::ofNullable);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.1.4")
    default public Arbitrary<List<T>> collect(Predicate<List<T>> until) {
        return genSize -> this.generator(genSize).collect(until);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ArbitraryFacade {
        private static ArbitraryFacade implementation = FacadeLoader.load(ArbitraryFacade.class);

        public abstract <T, U> Optional<ExhaustiveGenerator<U>> flatMapExhaustiveGenerator(ExhaustiveGenerator<T> var1, Function<T, Arbitrary<U>> var2);

        public abstract <T> SizableArbitrary<List<T>> list(Arbitrary<T> var1);

        public abstract <T> SizableArbitrary<List<T>> listOfUnique(Arbitrary<T> var1);

        public abstract <T> SizableArbitrary<Set<T>> set(Arbitrary<T> var1);

        public abstract <T> SizableArbitrary<Stream<T>> stream(Arbitrary<T> var1);

        public abstract <T> SizableArbitrary<Iterator<T>> iterator(Arbitrary<T> var1);

        public abstract <T, A> SizableArbitrary<A> array(Arbitrary<T> var1, Class<A> var2);

        public abstract <T, A> SizableArbitrary<A> arrayOfUnique(Arbitrary<T> var1, Class<A> var2);
    }
}

