/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.0")
public class FalsificationResult<T>
implements Comparable<FalsificationResult<T>> {
    private final Shrinkable<T> shrinkable;
    private final Status status;
    private final Throwable throwable;

    public static <T> FalsificationResult<T> falsified(Shrinkable<T> shrinkable) {
        return FalsificationResult.falsified(shrinkable, null);
    }

    public static <T> FalsificationResult<T> falsified(Shrinkable<T> shrinkable, Throwable throwable) {
        return new FalsificationResult<T>(shrinkable, Status.FALSIFIED, throwable);
    }

    public static <T> FalsificationResult<T> notFalsified(Shrinkable<T> shrinkable) {
        return new FalsificationResult<T>(shrinkable, Status.VERIFIED, null);
    }

    public static <T> FalsificationResult<T> filtered(Shrinkable<T> shrinkable) {
        return new FalsificationResult<T>(shrinkable, Status.FILTERED_OUT, null);
    }

    private FalsificationResult(Shrinkable<T> shrinkable, Status status, Throwable throwable) {
        this.shrinkable = shrinkable;
        this.status = status;
        this.throwable = throwable;
    }

    public Shrinkable<T> shrinkable() {
        return this.shrinkable;
    }

    public T value() {
        return this.shrinkable.value();
    }

    public ShrinkingDistance distance() {
        return this.shrinkable.distance();
    }

    public Status status() {
        return this.status;
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    @Override
    public int compareTo(FalsificationResult<T> other) {
        return this.shrinkable.compareTo(other.shrinkable);
    }

    public FalsificationResult<T> filter(Predicate<T> filter) {
        return new FalsificationResult<T>(this.shrinkable.filter(filter), this.status, this.throwable);
    }

    public <U> FalsificationResult<U> map(Function<Shrinkable<T>, Shrinkable<U>> mapper) {
        return new FalsificationResult<U>(mapper.apply(this.shrinkable()), this.status, this.throwable);
    }

    public static enum Status {
        FALSIFIED,
        VERIFIED,
        FILTERED_OUT;

    }
}

