/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.function.Predicate;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Shrinkable;
import org.apiguardian.api.API;
import org.opentest4j.TestAbortedException;

@FunctionalInterface
@API(status=API.Status.STABLE, since="1.0")
public interface Falsifier<T>
extends Predicate<T> {
    @API(status=API.Status.INTERNAL)
    default public Falsifier<T> withFilter(Predicate<T> filter) {
        return t -> {
            if (!filter.test(t)) {
                throw new TestAbortedException();
            }
            return this.test(t);
        };
    }

    @API(status=API.Status.INTERNAL)
    default public Falsifier<T> withPostFilter(Predicate<T> filter) {
        return t -> {
            try {
                boolean result;
                boolean bl = result = this.test(t);
                return bl;
            }
            finally {
                if (!filter.test(t)) {
                    throw new TestAbortedException();
                }
            }
        };
    }

    @API(status=API.Status.INTERNAL)
    default public FalsificationResult<T> falsify(Shrinkable<T> candidate) {
        try {
            boolean falsified;
            boolean bl = falsified = !this.test(candidate.value());
            if (falsified) {
                return FalsificationResult.falsified(candidate, null);
            }
            return FalsificationResult.notFalsified(candidate);
        }
        catch (TestAbortedException tae) {
            return FalsificationResult.filtered(candidate);
        }
        catch (Throwable throwable) {
            return FalsificationResult.falsified(candidate, throwable);
        }
    }
}

