/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.Shrinkable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public interface RandomGenerator<T> {
    public Shrinkable<T> next(Random var1);

    default public <U> RandomGenerator<U> map(Function<T, U> mapper) {
        return random -> this.next(random).map(mapper);
    }

    default public <U> RandomGenerator<U> flatMap(Function<T, RandomGenerator<U>> mapper) {
        return random -> {
            Shrinkable<T> wrappedShrinkable = this.next(random);
            return RandomGeneratorFacade.implementation.flatMap(wrappedShrinkable, mapper, random.nextLong());
        };
    }

    default public <U> RandomGenerator<U> flatMap(Function<T, Arbitrary<U>> mapper, int genSize) {
        return random -> {
            Shrinkable<T> wrappedShrinkable = this.next(random);
            return RandomGeneratorFacade.implementation.flatMap(wrappedShrinkable, mapper, genSize, random.nextLong());
        };
    }

    default public RandomGenerator<T> filter(Predicate<T> filterPredicate) {
        return RandomGeneratorFacade.implementation.filter(this, filterPredicate);
    }

    default public RandomGenerator<T> injectNull(double nullProbability) {
        return random -> {
            if (random.nextDouble() <= nullProbability) {
                return Shrinkable.unshrinkable(null);
            }
            return this.next(random);
        };
    }

    default public RandomGenerator<T> withEdgeCases(int genSize, List<Shrinkable<T>> edgeCases) {
        return RandomGeneratorFacade.implementation.withEdgeCases(this, genSize, edgeCases);
    }

    default public RandomGenerator<T> withSamples(T ... samples) {
        return RandomGeneratorFacade.implementation.withSamples(this, samples);
    }

    default public RandomGenerator<T> unique() {
        return RandomGeneratorFacade.implementation.unique(this);
    }

    default public Stream<Shrinkable<T>> stream(Random random) {
        return Stream.generate(() -> this.next(random));
    }

    default public RandomGenerator<List<T>> collect(Predicate<List<T>> until) {
        return RandomGeneratorFacade.implementation.collect(this, until);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class RandomGeneratorFacade {
        private static RandomGeneratorFacade implementation = FacadeLoader.load(RandomGeneratorFacade.class);

        public abstract <T, U> Shrinkable<U> flatMap(Shrinkable<T> var1, Function<T, RandomGenerator<U>> var2, long var3);

        public abstract <T, U> Shrinkable<U> flatMap(Shrinkable<T> var1, Function<T, Arbitrary<U>> var2, int var3, long var4);

        public abstract <T> RandomGenerator<T> filter(RandomGenerator<T> var1, Predicate<T> var2);

        public abstract <T> RandomGenerator<T> withEdgeCases(RandomGenerator<T> var1, int var2, List<Shrinkable<T>> var3);

        public abstract <T> RandomGenerator<T> withSamples(RandomGenerator<T> var1, T[] var2);

        public abstract <T> RandomGenerator<T> unique(RandomGenerator<T> var1);

        public abstract <T> RandomGenerator<List<T>> collect(RandomGenerator<T> var1, Predicate<List<T>> var2);
    }
}

