/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.Falsifier;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public interface Shrinkable<T>
extends Comparable<Shrinkable<T>> {
    public static <T> Shrinkable<T> unshrinkable(T value) {
        return ShrinkableFacade.implementation.unshrinkable(value);
    }

    public T value();

    public ShrinkingSequence<T> shrink(Falsifier<T> var1);

    public ShrinkingDistance distance();

    default public <U> Shrinkable<U> map(Function<T, U> mapper) {
        return ShrinkableFacade.implementation.map(this, mapper);
    }

    default public Shrinkable<T> filter(Predicate<T> filter) {
        return ShrinkableFacade.implementation.filter(this, filter);
    }

    @Override
    @API(status=API.Status.INTERNAL)
    default public int compareTo(Shrinkable<T> other) {
        return this.distance().compareTo(other.distance());
    }

    @API(status=API.Status.INTERNAL)
    default public boolean isSmallerThan(Shrinkable<T> other) {
        return this.distance().compareTo(other.distance()) < 0;
    }

    default public <U> Shrinkable<U> flatMap(Function<T, Arbitrary<U>> flatMapper, int tries, long randomSeed) {
        return ShrinkableFacade.implementation.flatMap(this, flatMapper, tries, randomSeed);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ShrinkableFacade {
        private static ShrinkableFacade implementation = FacadeLoader.load(ShrinkableFacade.class);

        public abstract <T> Shrinkable<T> unshrinkable(T var1);

        public abstract <T, U> Shrinkable<U> map(Shrinkable<T> var1, Function<T, U> var2);

        public abstract <T> Shrinkable<T> filter(Shrinkable<T> var1, Predicate<T> var2);

        public abstract <T, U> Shrinkable<U> flatMap(Shrinkable<T> var1, Function<T, Arbitrary<U>> var2, int var3, long var4);
    }
}

