/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import java.util.List;
import net.jqwik.api.lifecycle.LifecycleHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public interface AroundPropertyHook
extends LifecycleHook<AroundPropertyHook> {
    public static final AroundPropertyHook BASE = (propertyDescriptor, property) -> property.execute();

    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext var1, PropertyExecutor var2) throws Throwable;

    @Override
    default public int compareTo(AroundPropertyHook other) {
        return Integer.compare(this.aroundPropertyProximity(), other.aroundPropertyProximity());
    }

    default public int aroundPropertyProximity() {
        return 0;
    }

    default public AroundPropertyHook around(AroundPropertyHook inner) {
        return (context, property) -> {
            PropertyExecutor innerExecutor = () -> {
                try {
                    return inner.aroundProperty(context, property);
                }
                catch (Throwable throwable) {
                    return PropertyExecutionResult.failed(throwable, null, null);
                }
            };
            return this.aroundProperty(context, innerExecutor);
        };
    }

    public static AroundPropertyHook combine(List<AroundPropertyHook> aroundPropertyHooks) {
        if (aroundPropertyHooks.isEmpty()) {
            return BASE;
        }
        AroundPropertyHook first = aroundPropertyHooks.remove(0);
        return first.around(AroundPropertyHook.combine(aroundPropertyHooks));
    }
}

