/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.FacadeLoader;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.0")
public interface ExhaustiveGenerator<T>
extends Iterable<T> {
    @API(status=API.Status.INTERNAL, since="1.2.1")
    public static final long MAXIMUM_SAMPLES_TO_GENERATE = Integer.MAX_VALUE;

    public long maxCount();

    default public <U> ExhaustiveGenerator<U> map(Function<T, U> mapper) {
        return ExhaustiveGeneratorFacade.implementation.map(this, mapper);
    }

    default public ExhaustiveGenerator<T> filter(Predicate<T> filterPredicate) {
        return ExhaustiveGeneratorFacade.implementation.filter(this, filterPredicate);
    }

    @API(status=API.Status.INTERNAL)
    default public boolean isUnique() {
        return false;
    }

    default public ExhaustiveGenerator<T> unique() {
        return ExhaustiveGeneratorFacade.implementation.unique(this);
    }

    default public ExhaustiveGenerator<T> injectNull() {
        return ExhaustiveGeneratorFacade.implementation.injectNull(this);
    }

    default public ExhaustiveGenerator<T> withSamples(T[] samples) {
        return ExhaustiveGeneratorFacade.implementation.withSamples(this, samples);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ExhaustiveGeneratorFacade {
        private static ExhaustiveGeneratorFacade implementation = FacadeLoader.load(ExhaustiveGeneratorFacade.class);

        public abstract <T, U> ExhaustiveGenerator<U> map(ExhaustiveGenerator<T> var1, Function<T, U> var2);

        public abstract <T> ExhaustiveGenerator<T> filter(ExhaustiveGenerator<T> var1, Predicate<T> var2);

        public abstract <T> ExhaustiveGenerator<T> unique(ExhaustiveGenerator<T> var1);

        public abstract <T> ExhaustiveGenerator<T> injectNull(ExhaustiveGenerator<T> var1);

        public abstract <T> ExhaustiveGenerator<T> withSamples(ExhaustiveGenerator<T> var1, T[] var2);
    }
}

