/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public class PropertyExecutionResult {
    private final Status status;
    private final String seed;
    private final List<Object> falsifiedSample;
    private final Throwable throwable;

    private PropertyExecutionResult(Status status, String seed, Throwable throwable, List<Object> falsifiedSample) {
        this.status = status;
        this.seed = seed != null ? (seed.isEmpty() ? null : seed) : null;
        this.throwable = throwable;
        this.falsifiedSample = falsifiedSample;
    }

    public static PropertyExecutionResult successful() {
        return new PropertyExecutionResult(Status.SUCCESSFUL, null, null, null);
    }

    public static PropertyExecutionResult successful(String seed) {
        return new PropertyExecutionResult(Status.SUCCESSFUL, seed, null, null);
    }

    public static PropertyExecutionResult failed(Throwable throwable, String seed, List<Object> sample) {
        return new PropertyExecutionResult(Status.FAILED, seed, throwable, sample);
    }

    public static PropertyExecutionResult aborted(Throwable throwable, String seed) {
        return new PropertyExecutionResult(Status.ABORTED, seed, throwable, null);
    }

    public Optional<String> getSeed() {
        return Optional.ofNullable(this.seed);
    }

    public Optional<List<Object>> getFalsifiedSample() {
        return Optional.ofNullable(this.falsifiedSample);
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public String toString() {
        return String.format("PropertyExecutionResult[%s]", new Object[]{this.status});
    }

    public static enum Status {
        SUCCESSFUL,
        ABORTED,
        FAILED;

    }
}

