/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.Shrinkable;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.3.0")
public interface EdgeCases<T>
extends Iterable<Shrinkable<T>> {
    public List<Supplier<Shrinkable<T>>> suppliers();

    default public int size() {
        return this.suppliers().size();
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public Iterator<Shrinkable<T>> iterator() {
        return this.suppliers().stream().map(Supplier::get).iterator();
    }

    @API(status=API.Status.INTERNAL)
    public static <T> EdgeCases<T> fromSuppliers(List<Supplier<Shrinkable<T>>> suppliers) {
        return EdgeCasesFacade.implementation.fromSuppliers(suppliers);
    }

    @API(status=API.Status.INTERNAL)
    public static <T> EdgeCases<T> none() {
        return EdgeCases.fromSuppliers(Collections.emptyList());
    }

    @API(status=API.Status.INTERNAL)
    public static <T> EdgeCases<T> fromSupplier(Supplier<Shrinkable<T>> supplier) {
        return EdgeCases.fromSuppliers(Collections.singletonList(supplier));
    }

    @API(status=API.Status.INTERNAL)
    default public <U> EdgeCases<U> map(Function<T, U> mapper) {
        return this.mapShrinkable(tShrinkable -> tShrinkable.map(mapper));
    }

    @API(status=API.Status.INTERNAL)
    default public <U> EdgeCases<U> mapShrinkable(Function<Shrinkable<T>, Shrinkable<U>> mapper) {
        return EdgeCasesFacade.implementation.mapShrinkable(this, mapper);
    }

    @API(status=API.Status.INTERNAL)
    default public EdgeCases<T> filter(Predicate<T> filterPredicate) {
        return EdgeCasesFacade.implementation.filter(this, filterPredicate);
    }

    @API(status=API.Status.INTERNAL)
    default public <U> EdgeCases<U> flatMapArbitrary(Function<T, Arbitrary<U>> mapper) {
        return EdgeCasesFacade.implementation.flatMapArbitrary(this, mapper);
    }

    @API(status=API.Status.INTERNAL)
    default public EdgeCases<T> ignoreException(Class<? extends Throwable> exceptionType) {
        return EdgeCasesFacade.implementation.ignoreException(this, exceptionType);
    }

    @API(status=API.Status.INTERNAL)
    default public EdgeCases<T> dontShrink() {
        return () -> this.suppliers().stream().map((? super T supplier) -> () -> EdgeCases.lambda$null$1((Supplier)supplier)).collect(Collectors.toList());
    }

    private static /* synthetic */ Shrinkable lambda$null$1(Supplier supplier) {
        return ((Shrinkable)supplier.get()).makeUnshrinkable();
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class EdgeCasesFacade {
        private static final EdgeCasesFacade implementation = FacadeLoader.load(EdgeCasesFacade.class);

        public abstract <T> EdgeCases<T> fromSuppliers(List<Supplier<Shrinkable<T>>> var1);

        public abstract <T, U> EdgeCases<U> mapShrinkable(EdgeCases<T> var1, Function<Shrinkable<T>, Shrinkable<U>> var2);

        public abstract <T, U> EdgeCases<U> flatMapArbitrary(EdgeCases<T> var1, Function<T, Arbitrary<U>> var2);

        public abstract <T> EdgeCases<T> filter(EdgeCases<T> var1, Predicate<T> var2);

        public abstract <T> EdgeCases<T> ignoreException(EdgeCases<T> var1, Class<? extends Throwable> var2);
    }
}

