/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.ShrinkingMode;
import net.jqwik.api.lifecycle.AddLifecycleHook;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.PropertyAttributes;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import org.apiguardian.api.API;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@AddLifecycleHook(value=PropertyDefaultsHook.class)
@API(status=API.Status.EXPERIMENTAL, since="1.3.4")
public @interface PropertyDefaults {
    public int tries() default 0;

    public AfterFailureMode afterFailure() default AfterFailureMode.NOT_SET;

    public ShrinkingMode shrinking() default ShrinkingMode.NOT_SET;

    public GenerationMode generation() default GenerationMode.NOT_SET;

    public EdgeCasesMode edgeCases() default EdgeCasesMode.NOT_SET;

    public static class PropertyDefaultsHook
    implements AroundPropertyHook {
        @Override
        public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) {
            List<PropertyDefaults> propertyDefaults = context.findAnnotationsInContainer(PropertyDefaults.class);
            this.findTries(propertyDefaults).ifPresent(tries -> {
                PropertyAttributes attributes = context.attributes();
                if (!attributes.tries().isPresent()) {
                    attributes.setTries((Integer)tries);
                }
            });
            this.findAfterFailure(propertyDefaults).ifPresent(afterFailure -> {
                PropertyAttributes attributes = context.attributes();
                if (!attributes.afterFailure().isPresent()) {
                    attributes.setAfterFailure((AfterFailureMode)((Object)afterFailure));
                }
            });
            this.findShrinking(propertyDefaults).ifPresent(shrinking -> {
                PropertyAttributes attributes = context.attributes();
                if (!attributes.shrinking().isPresent()) {
                    attributes.setShrinking((ShrinkingMode)((Object)shrinking));
                }
            });
            this.findGeneration(propertyDefaults).ifPresent(generation -> {
                PropertyAttributes attributes = context.attributes();
                if (!attributes.generation().isPresent()) {
                    attributes.setGeneration((GenerationMode)((Object)generation));
                }
            });
            this.findEdgeCases(propertyDefaults).ifPresent(edgeCases -> {
                PropertyAttributes attributes = context.attributes();
                if (!attributes.edgeCases().isPresent()) {
                    attributes.setEdgeCases((EdgeCasesMode)((Object)edgeCases));
                }
            });
            return property.execute();
        }

        private Optional<Integer> findTries(List<PropertyDefaults> propertyDefaults) {
            return propertyDefaults.stream().map(PropertyDefaults::tries).filter(tries -> tries != 0).findFirst();
        }

        private Optional<AfterFailureMode> findAfterFailure(List<PropertyDefaults> propertyDefaults) {
            return propertyDefaults.stream().map(PropertyDefaults::afterFailure).filter(afterFailure -> afterFailure != AfterFailureMode.NOT_SET).findFirst();
        }

        private Optional<ShrinkingMode> findShrinking(List<PropertyDefaults> propertyDefaults) {
            return propertyDefaults.stream().map(PropertyDefaults::shrinking).filter(shrinking -> shrinking != ShrinkingMode.NOT_SET).findFirst();
        }

        private Optional<GenerationMode> findGeneration(List<PropertyDefaults> propertyDefaults) {
            return propertyDefaults.stream().map(PropertyDefaults::generation).filter(generation -> generation != GenerationMode.NOT_SET).findFirst();
        }

        private Optional<EdgeCasesMode> findEdgeCases(List<PropertyDefaults> propertyDefaults) {
            return propertyDefaults.stream().map(PropertyDefaults::edgeCases).filter(edgeCases -> edgeCases != EdgeCasesMode.NOT_SET).findFirst();
        }

        @Override
        public int aroundPropertyProximity() {
            return -10;
        }

        @Override
        public PropagationMode propagateTo() {
            return PropagationMode.ALL_DESCENDANTS;
        }

        @Override
        public boolean appliesTo(Optional<AnnotatedElement> element) {
            return element.map(e -> e instanceof Method).orElse(false);
        }
    }
}

