/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.statistics;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Tuple;
import net.jqwik.api.statistics.Histogram;
import net.jqwik.api.statistics.StatisticsEntry;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.3.0")
public class NumberRangeHistogram
extends Histogram {
    protected int buckets() {
        return 20;
    }

    protected String rangeLabel(BigInteger min, BigInteger max, boolean maxIncluded) {
        return String.format("[%s..%s", min, max) + (maxIncluded ? (char)']' : '[');
    }

    @Override
    protected final String label(StatisticsEntry entry) {
        return "not used";
    }

    @Override
    protected final Comparator<? super StatisticsEntry> comparator() {
        return (left, right) -> 0;
    }

    @Override
    protected final List<Histogram.Bucket> cluster(List<StatisticsEntry> entries) {
        Tuple.Tuple2<BigInteger, BigInteger> minMax = this.minMax(entries);
        BigInteger min = (BigInteger)minMax.get1();
        BigInteger max = minMax.get2();
        List<Tuple.Tuple2<BigInteger, Histogram.Bucket>> topsAndBuckets = this.topsAndBuckets(min, max);
        for (StatisticsEntry entry : entries) {
            Histogram.Bucket bucket = this.findBucket(topsAndBuckets, this.value(entry));
            bucket.addCount(entry.count());
        }
        return topsAndBuckets.stream().map(Tuple.Tuple2::get2).collect(Collectors.toList());
    }

    private Histogram.Bucket findBucket(List<Tuple.Tuple2<BigInteger, Histogram.Bucket>> topsAndBuckets, BigDecimal value) {
        for (int i = 0; i < topsAndBuckets.size(); ++i) {
            Tuple.Tuple2<BigInteger, Histogram.Bucket> topAndBucket = topsAndBuckets.get(i);
            BigInteger top = (BigInteger)topAndBucket.get1();
            if (value.compareTo(new BigDecimal(top)) < 0) {
                return topAndBucket.get2();
            }
            if (i != topsAndBuckets.size() - 1) continue;
            return topAndBucket.get2();
        }
        throw new RuntimeException(String.format("No bucket found for value [%s]", value));
    }

    private List<Tuple.Tuple2<BigInteger, Histogram.Bucket>> topsAndBuckets(BigInteger min, BigInteger max) {
        BigInteger range = max.subtract(min);
        BigInteger numberOfBuckets = BigInteger.valueOf(this.buckets());
        BigInteger step = range.divide(numberOfBuckets);
        BigInteger remainder = range.remainder(numberOfBuckets);
        if (remainder.compareTo(BigInteger.ZERO) != 0) {
            step = step.add(BigInteger.ONE);
        }
        ArrayList<Tuple.Tuple2<BigInteger, Histogram.Bucket>> topsAndBuckets = new ArrayList<Tuple.Tuple2<BigInteger, Histogram.Bucket>>();
        BigInteger left = min;
        BigInteger index = min.add(step);
        while (index.compareTo(max) < 0) {
            String label = this.rangeLabel(left, index, false);
            topsAndBuckets.add(Tuple.of(index, new Histogram.Bucket(label)));
            left = index;
            index = index.add(step);
        }
        String label = this.rangeLabel(left, max, true);
        topsAndBuckets.add(Tuple.of(max, new Histogram.Bucket(label)));
        return topsAndBuckets;
    }

    private Tuple.Tuple2<BigInteger, BigInteger> minMax(List<StatisticsEntry> entries) {
        BigDecimal min = null;
        BigDecimal max = null;
        for (StatisticsEntry entry : entries) {
            try {
                BigDecimal value = this.value(entry);
                if (min == null || value.compareTo(min) < 0) {
                    min = value;
                }
                if (max != null && value.compareTo(max) <= 0) continue;
                max = value;
            }
            catch (NumberFormatException numberFormatException) {
                String message = String.format("NumberRangeHistogram instances only accept numeric values. [%s] is not numeric.", entry.values().get(0));
                throw new JqwikException(message);
            }
        }
        BigInteger maxBigInteger = max.setScale(0, 0).toBigInteger();
        return Tuple.of(min.toBigInteger(), maxBigInteger);
    }

    private BigDecimal value(StatisticsEntry entry) {
        if (entry.values().size() != 1) {
            String message = String.format("NumberRangeHistogram instances only single value. Wrong value: %s.", entry.values());
            throw new JqwikException(message);
        }
        return new BigDecimal(entry.values().get(0).toString());
    }
}

