/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.Shrinkable;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.3.0")
public interface EdgeCases<T>
extends Iterable<Shrinkable<T>> {
    public List<Supplier<Shrinkable<T>>> suppliers();

    default public int size() {
        return this.suppliers().size();
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public Iterator<Shrinkable<T>> iterator() {
        return this.suppliers().stream().map(Supplier::get).iterator();
    }

    @API(status=API.Status.INTERNAL)
    public static <T> EdgeCases<T> fromSuppliers(List<Supplier<Shrinkable<T>>> suppliers) {
        return EdgeCasesFacade.implementation.fromSuppliers(suppliers);
    }

    @API(status=API.Status.INTERNAL)
    public static <T> EdgeCases<T> none() {
        return EdgeCases.fromSuppliers(Collections.emptyList());
    }

    @API(status=API.Status.INTERNAL)
    public static <T> EdgeCases<T> fromSupplier(Supplier<Shrinkable<T>> supplier) {
        return EdgeCases.fromSuppliers(Collections.singletonList(supplier));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3.9")
    public static interface Config<T> {
        public Config<T> none();

        public Config<T> filter(Predicate<T> var1);

        public Config<T> add(T var1);

        public Config<T> includeOnly(T ... var1);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class EdgeCasesFacade {
        private static final EdgeCasesFacade implementation = FacadeLoader.load(EdgeCasesFacade.class);

        public abstract <T> EdgeCases<T> fromSuppliers(List<Supplier<Shrinkable<T>>> var1);
    }
}

