/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.ArrayArbitrary;
import net.jqwik.api.arbitraries.IteratorArbitrary;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.arbitraries.StreamArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public interface Arbitrary<T> {
    public RandomGenerator<T> generator(int var1);

    @API(status=API.Status.INTERNAL, since="1.4.0")
    default public RandomGenerator<T> generator(int genSize, boolean withEdgeCases) {
        return ArbitraryFacade.implementation.memoizedGenerator(this, genSize, withEdgeCases);
    }

    @API(status=API.Status.INTERNAL, since="1.4.0")
    default public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.generator(genSize);
    }

    @API(status=API.Status.INTERNAL)
    default public Arbitrary<Object> asGeneric() {
        return this;
    }

    @API(status=API.Status.INTERNAL)
    default public Optional<ExhaustiveGenerator<T>> exhaustive() {
        return this.exhaustive(Integer.MAX_VALUE);
    }

    @API(status=API.Status.INTERNAL)
    default public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        return Optional.empty();
    }

    public EdgeCases<T> edgeCases(int var1);

    @API(status=API.Status.EXPERIMENTAL, since="1.3.0")
    default public EdgeCases<T> edgeCases() {
        return this.edgeCases(1000);
    }

    default public Optional<Stream<T>> allValues() {
        return this.exhaustive().map((? super T generator) -> StreamSupport.stream(generator.spliterator(), false));
    }

    @API(status=API.Status.MAINTAINED, since="1.1.2")
    default public void forEachValue(Consumer<? super T> action) {
        if (!this.allValues().isPresent()) {
            throw new AssertionError((Object)("Cannot generate all values of " + this.toString()));
        }
        this.allValues().ifPresent(stream -> stream.forEach(action::accept));
    }

    default public Arbitrary<T> filter(Predicate<T> filterPredicate) {
        return ArbitraryFacade.implementation.filter(this, filterPredicate);
    }

    default public <U> Arbitrary<U> map(Function<T, U> mapper) {
        return ArbitraryFacade.implementation.map(this, mapper);
    }

    default public <U> Arbitrary<U> flatMap(Function<T, Arbitrary<U>> mapper) {
        return ArbitraryFacade.implementation.flatMap(this, mapper);
    }

    default public Arbitrary<T> injectNull(double nullProbability) {
        return ArbitraryFacade.implementation.injectNull(this, nullProbability);
    }

    @API(status=API.Status.MAINTAINED, since="1.2.0")
    default public Arbitrary<T> fixGenSize(final int genSize) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int ignoredGenSize) {
                return Arbitrary.this.generator(genSize);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples);
            }

            @Override
            public EdgeCases<T> edgeCases(int maxEdgeCases) {
                return Arbitrary.this.edgeCases(maxEdgeCases);
            }
        };
    }

    default public ListArbitrary<T> list() {
        return ArbitraryFacade.implementation.list(this);
    }

    default public SetArbitrary<T> set() {
        return ArbitraryFacade.implementation.set(this);
    }

    default public StreamArbitrary<T> stream() {
        return ArbitraryFacade.implementation.stream(this);
    }

    default public IteratorArbitrary<T> iterator() {
        return ArbitraryFacade.implementation.iterator(this);
    }

    default public <A> ArrayArbitrary<T, A> array(Class<A> arrayClass) {
        return ArbitraryFacade.implementation.array(this, arrayClass);
    }

    default public Arbitrary<Optional<T>> optional() {
        return this.injectNull(0.05).map(Optional::ofNullable);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<List<T>> collect(final Predicate<List<T>> until) {
        return new Arbitrary<List<T>>(){

            @Override
            public RandomGenerator<List<T>> generator(int genSize) {
                return Arbitrary.this.generator(genSize).collect(until);
            }

            @Override
            public EdgeCases<List<T>> edgeCases(int maxEdgeCases) {
                return EdgeCases.none();
            }
        };
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Stream<T> sampleStream() {
        return ArbitraryFacade.implementation.sampleStream(this);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public T sample() {
        return this.sampleStream().map(Optional::ofNullable).findFirst().orElseThrow(() -> new JqwikException("Cannot generate a value")).orElse(null);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<T> injectDuplicates(final double duplicateProbability) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).injectDuplicates(duplicateProbability);
            }

            @Override
            public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
                return Arbitrary.this.generator(genSize, true).injectDuplicates(duplicateProbability);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples);
            }

            @Override
            public EdgeCases<T> edgeCases(int maxEdgeCases) {
                if (duplicateProbability >= 1.0) {
                    return EdgeCases.none();
                }
                return Arbitrary.this.edgeCases(maxEdgeCases);
            }
        };
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<Tuple.Tuple1<T>> tuple1() {
        return this.map(Tuple::of);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<Tuple.Tuple2<T, T>> tuple2() {
        return this.list().ofSize(2).map(l -> Tuple.of(l.get(0), l.get(1)));
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<Tuple.Tuple3<T, T, T>> tuple3() {
        return this.list().ofSize(3).map(l -> Tuple.of(l.get(0), l.get(1), l.get(2)));
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    default public Arbitrary<Tuple.Tuple4<T, T, T, T>> tuple4() {
        return this.list().ofSize(4).map(l -> Tuple.of(l.get(0), l.get(1), l.get(2), l.get(3)));
    }

    @API(status=API.Status.MAINTAINED, since="1.3.3")
    default public Arbitrary<Tuple.Tuple5<T, T, T, T, T>> tuple5() {
        return this.list().ofSize(5).map(l -> Tuple.of(l.get(0), l.get(1), l.get(2), l.get(3), l.get(4)));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3.1")
    default public Arbitrary<T> ignoreException(Class<? extends Throwable> exceptionType) {
        return ArbitraryFacade.implementation.ignoreException(this, exceptionType);
    }

    @API(status=API.Status.MAINTAINED, since="1.4.0")
    default public Arbitrary<T> dontShrink() {
        return ArbitraryFacade.implementation.dontShrink(this);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3.9")
    default public Arbitrary<T> edgeCases(Consumer<EdgeCases.Config<T>> configurator) {
        return ArbitraryFacade.implementation.configureEdgeCases(this, configurator);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.4.0")
    default public Arbitrary<T> withoutEdgeCases() {
        return ArbitraryFacade.implementation.withoutEdgeCases(this);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ArbitraryFacade {
        private static final ArbitraryFacade implementation = FacadeLoader.load(ArbitraryFacade.class);

        public abstract <T> ListArbitrary<T> list(Arbitrary<T> var1);

        public abstract <T> SetArbitrary<T> set(Arbitrary<T> var1);

        public abstract <T> StreamArbitrary<T> stream(Arbitrary<T> var1);

        public abstract <T> IteratorArbitrary<T> iterator(Arbitrary<T> var1);

        public abstract <T, A> ArrayArbitrary<T, A> array(Arbitrary<T> var1, Class<A> var2);

        public abstract <T> Stream<T> sampleStream(Arbitrary<T> var1);

        public abstract <T> Arbitrary<T> injectNull(Arbitrary<T> var1, double var2);

        public abstract <T> Arbitrary<T> filter(Arbitrary<T> var1, Predicate<T> var2);

        public abstract <T, U> Arbitrary<U> map(Arbitrary<T> var1, Function<T, U> var2);

        public abstract <T, U> Arbitrary<U> flatMap(Arbitrary<T> var1, Function<T, Arbitrary<U>> var2);

        public abstract <T> Arbitrary<T> ignoreException(Arbitrary<T> var1, Class<? extends Throwable> var2);

        public abstract <T> Arbitrary<T> dontShrink(Arbitrary<T> var1);

        public abstract <T> Arbitrary<T> configureEdgeCases(Arbitrary<T> var1, Consumer<EdgeCases.Config<T>> var2);

        public abstract <T> Arbitrary<T> withoutEdgeCases(Arbitrary<T> var1);

        public abstract <T> RandomGenerator<T> memoizedGenerator(Arbitrary<T> var1, int var2, boolean var3);
    }
}

