/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.4.0")
public interface TryExecutionResult {
    public static TryExecutionResult satisfied() {
        return TryExecutionResult.satisfied(false);
    }

    public static TryExecutionResult satisfied(final boolean shouldPropertyFinishEarly) {
        return new TryExecutionResult(){

            @Override
            public Status status() {
                return Status.SATISFIED;
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.empty();
            }

            @Override
            public boolean shouldPropertyFinishEarly() {
                return shouldPropertyFinishEarly;
            }

            public String toString() {
                return String.format("TryExecutionResult(%s)", this.status().name());
            }
        };
    }

    public static TryExecutionResult falsified(final Throwable throwable) {
        return new TryExecutionResult(){

            @Override
            public Status status() {
                return Status.FALSIFIED;
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.ofNullable(throwable);
            }

            @Override
            public boolean shouldPropertyFinishEarly() {
                return false;
            }

            public String toString() {
                return String.format("TryExecutionResult(%s): %s", this.status().name(), this.throwable().map(Throwable::getMessage).orElse("null"));
            }
        };
    }

    public static TryExecutionResult invalid(final Throwable throwable) {
        return new TryExecutionResult(){

            @Override
            public Status status() {
                return Status.INVALID;
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.ofNullable(throwable);
            }

            @Override
            public boolean shouldPropertyFinishEarly() {
                return false;
            }

            public String toString() {
                return String.format("TryExecutionResult(%s)", this.status().name());
            }
        };
    }

    public static TryExecutionResult invalid() {
        return TryExecutionResult.invalid(null);
    }

    default public boolean isSatisfied() {
        return this.status() == Status.SATISFIED;
    }

    default public boolean isFalsified() {
        return this.status() == Status.FALSIFIED;
    }

    default public boolean isInvalid() {
        return this.status() == Status.INVALID;
    }

    public Status status();

    public Optional<Throwable> throwable();

    public boolean shouldPropertyFinishEarly();

    public static enum Status {
        SATISFIED,
        FALSIFIED,
        INVALID;

    }
}

