/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.CannotFindStoreException;
import net.jqwik.api.lifecycle.Lifespan;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.2.3")
public interface Store<T> {
    public T get();

    public Lifespan lifespan();

    public void update(Function<T, T> var1);

    public void reset();

    @API(status=API.Status.EXPERIMENTAL, since="1.2.4")
    public Store<T> onClose(Consumer<T> var1);

    public static <T> Store<T> create(Object identifier, Lifespan lifespan, Supplier<T> initializer) {
        return StoreFacade.implementation.create(identifier, lifespan, initializer);
    }

    public static <T> Store<T> getOrCreate(Object identifier, Lifespan lifespan, Supplier<T> initializer) {
        try {
            Store<T> store = Store.get(identifier);
            if (!store.lifespan().equals((Object)lifespan)) {
                String message = String.format("Trying to recreate existing store [%s] with different lifespan [%s]", new Object[]{store, lifespan});
                throw new JqwikException(message);
            }
            return store;
        }
        catch (CannotFindStoreException cannotFindStore) {
            return Store.create(identifier, lifespan, initializer);
        }
    }

    public static <T> Store<T> get(Object identifier) {
        return StoreFacade.implementation.get(identifier);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.5.0")
    public static <T> Store<T> free(Supplier<T> initializer) {
        return StoreFacade.implementation.free(initializer);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class StoreFacade {
        private static final StoreFacade implementation = FacadeLoader.load(StoreFacade.class);

        public abstract <T> Store<T> create(Object var1, Lifespan var2, Supplier<T> var3);

        public abstract <T> Store<T> get(Object var1);

        public abstract <T> Store<T> free(Supplier<T> var1);
    }
}

