/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.statistics;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import net.jqwik.api.statistics.StatisticsEntry;
import net.jqwik.api.statistics.StatisticsReportFormat;
import net.jqwik.api.statistics.StatisticsReportList;
import org.apiguardian.api.API;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Repeatable(value=StatisticsReportList.class)
@API(status=API.Status.EXPERIMENTAL, since="1.2.3")
public @interface StatisticsReport {
    public static final String ALL_LABELS = "";

    public StatisticsReportMode value() default StatisticsReportMode.PLUG_IN;

    public Class<? extends StatisticsReportFormat> format() default None.class;

    @API(status=API.Status.EXPERIMENTAL, since="1.5.1")
    public String label() default "";

    @API(status=API.Status.EXPERIMENTAL, since="1.5.5")
    public boolean onFailureOnly() default false;

    public static enum StatisticsReportMode {
        OFF,
        STANDARD,
        PLUG_IN;

    }

    @API(status=API.Status.INTERNAL)
    public static class None
    implements StatisticsReportFormat {
        @Override
        public List<String> formatReport(List<StatisticsEntry> entries) {
            throw new UnsupportedOperationException("This format should never be used");
        }
    }
}

