/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.ShrunkFalsifiedSample;
import org.apiguardian.api.API;
import org.opentest4j.AssertionFailedError;

@API(status=API.Status.MAINTAINED, since="1.4.0")
public interface PropertyExecutionResult {
    public Optional<String> seed();

    public Optional<List<Object>> falsifiedParameters();

    public Status status();

    public Optional<Throwable> throwable();

    public int countChecks();

    public int countTries();

    @API(status=API.Status.EXPERIMENTAL, since="1.3.5")
    public Optional<FalsifiedSample> originalSample();

    @API(status=API.Status.EXPERIMENTAL, since="1.3.5")
    public Optional<ShrunkFalsifiedSample> shrunkSample();

    public PropertyExecutionResult mapTo(Status var1, @Nullable Throwable var2);

    default public PropertyExecutionResult mapToSuccessful() {
        if (this.status() == Status.SUCCESSFUL) {
            return this;
        }
        return this.mapTo(Status.SUCCESSFUL, null);
    }

    default public PropertyExecutionResult mapToFailed(@Nullable Throwable throwable) {
        return this.mapTo(Status.FAILED, throwable);
    }

    default public PropertyExecutionResult mapToFailed(String message) {
        return this.mapToFailed((Throwable)new AssertionFailedError(message));
    }

    default public PropertyExecutionResult mapToAborted(@Nullable Throwable throwable) {
        return this.mapTo(Status.ABORTED, throwable);
    }

    public static enum Status {
        SUCCESSFUL,
        ABORTED,
        FAILED;

    }
}

