/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.Tuple;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.MAINTAINED, since="1.5.4")
public class Builders {
    private Builders() {
    }

    public static <B> BuilderCombinator<B> withBuilder(Supplier<B> builderSupplier) {
        return new BuilderCombinator(builderSupplier, Collections.emptyList());
    }

    public static class BuilderCombinator<B> {
        private final Supplier<B> starter;
        private final List<Tuple.Tuple3<Double, Arbitrary<Object>, BiFunction<B, Object, B>>> mutators;

        private BuilderCombinator(Supplier<B> starter, List<Tuple.Tuple3<Double, Arbitrary<Object>, BiFunction<B, Object, B>>> mutators) {
            this.starter = starter;
            this.mutators = mutators;
        }

        public <T> CombinableBuilder<B, T> use(Arbitrary<T> arbitrary) {
            return new CombinableBuilder(this, 1.0, arbitrary);
        }

        public <T> Arbitrary<T> build(Function<B, T> buildFunction) {
            class Holder {
                @Nullable
                final Object value;

                Holder(Object value) {
                    this.value = value;
                }
            }
            List arbitraries = this.mutators.stream().map(mutator -> {
                double presenceProbability = (Double)mutator.get1();
                Arbitrary<Holder> nullable = ((Arbitrary)mutator.get2()).map(value -> new Holder(value));
                return nullable.optional(presenceProbability);
            }).collect(Collectors.toList());
            Arbitrary<Object> aBuilder = Combinators.combine(arbitraries).as(values -> {
                B builder = this.starter.get();
                for (int i = 0; i < values.size(); ++i) {
                    Optional optional = (Optional)values.get(i);
                    if (!optional.isPresent()) continue;
                    Object value = ((Holder)optional.get()).value;
                    BiFunction<B, Object, B> mutator = this.mutators.get(i).get3();
                    builder = mutator.apply(builder, value);
                }
                return builder;
            });
            return aBuilder.map(buildFunction);
        }

        public Arbitrary<B> build() {
            return this.build(Function.identity());
        }

        BuilderCombinator<B> withMutator(double probabilityOfUse, Arbitrary<Object> arbitrary, BiFunction<B, Object, B> mutate) {
            ArrayList<Tuple.Tuple3<Double, Arbitrary<Object>, BiFunction<B, Object, B>>> newMutators = new ArrayList<Tuple.Tuple3<Double, Arbitrary<Object>, BiFunction<B, Object, B>>>(this.mutators);
            newMutators.add(Tuple.of(probabilityOfUse, arbitrary, mutate));
            return new BuilderCombinator<B>(this.starter, newMutators);
        }
    }

    public static class CombinableBuilder<B, T> {
        private final BuilderCombinator<B> combinator;
        private final double probabilityOfUse;
        private final Arbitrary<T> arbitrary;

        private CombinableBuilder(BuilderCombinator<B> combinator, double probabilityOfUse, Arbitrary<T> arbitrary) {
            this.combinator = combinator;
            this.probabilityOfUse = probabilityOfUse;
            this.arbitrary = arbitrary;
        }

        public CombinableBuilder<B, T> withProbability(double probabilityOfUse) {
            if (probabilityOfUse < 0.0 || probabilityOfUse > 1.0) {
                String message = String.format("Usage probability of [%s] is outside allowed range (0;1)", probabilityOfUse);
                throw new IllegalArgumentException(message);
            }
            return new CombinableBuilder<B, T>(this.combinator, probabilityOfUse, this.arbitrary);
        }

        public BuilderCombinator<B> in(BiFunction<B, T, B> toFunction) {
            if (this.probabilityOfUse == 0.0) {
                return this.combinator;
            }
            BiFunction<Object, Object, Object> mutate = (builder, object) -> toFunction.apply(builder, object);
            return this.combinator.withMutator(this.probabilityOfUse, this.arbitrary.asGeneric(), mutate);
        }

        public BuilderCombinator<B> inSetter(BiConsumer<B, T> setter) {
            BiFunction<Object, Object, Object> toFunction = (b, t) -> {
                setter.accept(b, t);
                return b;
            };
            return this.in(toFunction);
        }
    }
}

