/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.List;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.FacadeLoader;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.MAINTAINED, since="1.0")
public class Combinators {
    private Combinators() {
    }

    public static <T1, T2> Combinator2<T1, T2> combine(Arbitrary<T1> a1, Arbitrary<T2> a2) {
        return new Combinator2(a1, a2);
    }

    public static <T1, T2, T3> Combinator3<T1, T2, T3> combine(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3) {
        return new Combinator3(a1, a2, a3);
    }

    public static <T1, T2, T3, T4> Combinator4<T1, T2, T3, T4> combine(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4) {
        return new Combinator4(a1, a2, a3, a4);
    }

    public static <T1, T2, T3, T4, T5> Combinator5<T1, T2, T3, T4, T5> combine(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5) {
        return new Combinator5(a1, a2, a3, a4, a5);
    }

    public static <T1, T2, T3, T4, T5, T6> Combinator6<T1, T2, T3, T4, T5, T6> combine(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6) {
        return new Combinator6(a1, a2, a3, a4, a5, a6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Combinator7<T1, T2, T3, T4, T5, T6, T7> combine(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7) {
        return new Combinator7(a1, a2, a3, a4, a5, a6, a7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Combinator8<T1, T2, T3, T4, T5, T6, T7, T8> combine(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7, Arbitrary<T8> a8) {
        return new Combinator8(a1, a2, a3, a4, a5, a6, a7, a8);
    }

    public static <T> ListCombinator<T> combine(List<Arbitrary<T>> listOfArbitraries) {
        return new ListCombinator(listOfArbitraries);
    }

    private static <T1, T2, R> Function<List<Object>, R> combineFunction(F2<T1, T2, R> combinator2) {
        return params -> combinator2.apply(params.get(0), params.get(1));
    }

    private static <T1, T2, T3, R> Function<List<Object>, R> combineFunction(F3<T1, T2, T3, R> combinator3) {
        return params -> combinator3.apply(params.get(0), params.get(1), params.get(2));
    }

    private static <T1, T2, T3, T4, R> Function<List<Object>, R> combineFunction(F4<T1, T2, T3, T4, R> combinator4) {
        return params -> combinator4.apply(params.get(0), params.get(1), params.get(2), params.get(3));
    }

    private static <T1, T2, T3, T4, T5, R> Function<List<Object>, R> combineFunction(F5<T1, T2, T3, T4, T5, R> combinator5) {
        return params -> combinator5.apply(params.get(0), params.get(1), params.get(2), params.get(3), params.get(4));
    }

    private static <T1, T2, T3, T4, T5, T6, R> Function<List<Object>, R> combineFunction(F6<T1, T2, T3, T4, T5, T6, R> combinator6) {
        return params -> combinator6.apply(params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5));
    }

    private static <T1, T2, T3, T4, T5, T6, T7, R> Function<List<Object>, R> combineFunction(F7<T1, T2, T3, T4, T5, T6, T7, R> combinator7) {
        return params -> combinator7.apply(params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6));
    }

    private static <T1, T2, T3, T4, T5, T6, T7, T8, R> Function<List<Object>, R> combineFunction(F8<T1, T2, T3, T4, T5, T6, T7, T8, R> combinator8) {
        return params -> combinator8.apply(params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6), params.get(7));
    }

    @FunctionalInterface
    @API(status=API.Status.INTERNAL)
    public static interface F8<T1, T2, T3, T4, T5, T6, T7, T8, R> {
        public R apply(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5, T6 var6, T7 var7, T8 var8);
    }

    @FunctionalInterface
    @API(status=API.Status.INTERNAL)
    public static interface F7<T1, T2, T3, T4, T5, T6, T7, R> {
        public R apply(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5, T6 var6, T7 var7);
    }

    @FunctionalInterface
    @API(status=API.Status.INTERNAL)
    public static interface F6<T1, T2, T3, T4, T5, T6, R> {
        public R apply(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5, T6 var6);
    }

    @FunctionalInterface
    @API(status=API.Status.INTERNAL)
    public static interface F5<T1, T2, T3, T4, T5, R> {
        public R apply(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5);
    }

    @FunctionalInterface
    @API(status=API.Status.INTERNAL)
    public static interface F4<T1, T2, T3, T4, R> {
        public R apply(T1 var1, T2 var2, T3 var3, T4 var4);
    }

    @FunctionalInterface
    @API(status=API.Status.INTERNAL)
    public static interface F3<T1, T2, T3, R> {
        public R apply(T1 var1, T2 var2, T3 var3);
    }

    @FunctionalInterface
    @API(status=API.Status.INTERNAL)
    public static interface F2<T1, T2, R> {
        public R apply(T1 var1, T2 var2);
    }

    public static class Combinator2<T1, T2> {
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;

        private Combinator2(Arbitrary<T1> a1, Arbitrary<T2> a2) {
            this.a1 = a1;
            this.a2 = a2;
        }

        public <R> Arbitrary<R> as(F2<T1, T2, @NotNull R> combinator) {
            return CombinatorsFacade.implementation.combine(Combinators.combineFunction(combinator), this.a1, this.a2);
        }

        public <R> Arbitrary<R> flatAs(F2<T1, T2, Arbitrary<@NotNull R>> flatCombinator) {
            return this.as(flatCombinator).flatMap(Function.identity());
        }
    }

    public static class Combinator3<T1, T2, T3> {
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;

        private Combinator3(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3) {
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
        }

        public <R> Arbitrary<R> as(F3<T1, T2, T3, @NotNull R> combinator) {
            return CombinatorsFacade.implementation.combine(Combinators.combineFunction(combinator), this.a1, this.a2, this.a3);
        }

        public <R> Arbitrary<R> flatAs(F3<T1, T2, T3, Arbitrary<@NotNull R>> flatCombinator) {
            return this.as(flatCombinator).flatMap(Function.identity());
        }
    }

    public static class Combinator4<T1, T2, T3, T4> {
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;

        private Combinator4(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4) {
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
        }

        public <R> Arbitrary<R> as(F4<T1, T2, T3, T4, @NotNull R> combinator) {
            return CombinatorsFacade.implementation.combine(Combinators.combineFunction(combinator), this.a1, this.a2, this.a3, this.a4);
        }

        public <R> Arbitrary<R> flatAs(F4<T1, T2, T3, T4, Arbitrary<@NotNull R>> flatCombinator) {
            return this.as(flatCombinator).flatMap(Function.identity());
        }
    }

    public static class Combinator5<T1, T2, T3, T4, T5> {
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;

        private Combinator5(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5) {
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
        }

        public <R> Arbitrary<R> as(F5<T1, T2, T3, T4, T5, @NotNull R> combinator) {
            return CombinatorsFacade.implementation.combine(Combinators.combineFunction(combinator), this.a1, this.a2, this.a3, this.a4, this.a5);
        }

        public <R> Arbitrary<R> flatAs(F5<T1, T2, T3, T4, T5, Arbitrary<@NotNull R>> flatCombinator) {
            return this.as(flatCombinator).flatMap(Function.identity());
        }
    }

    public static class Combinator6<T1, T2, T3, T4, T5, T6> {
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final Arbitrary<T6> a6;

        private Combinator6(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6) {
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.a6 = a6;
        }

        public <R> Arbitrary<R> as(F6<T1, T2, T3, T4, T5, T6, @NotNull R> combinator) {
            return CombinatorsFacade.implementation.combine(Combinators.combineFunction(combinator), this.a1, this.a2, this.a3, this.a4, this.a5, this.a6);
        }

        public <R> Arbitrary<R> flatAs(F6<T1, T2, T3, T4, T5, T6, Arbitrary<@NotNull R>> flatCombinator) {
            return this.as(flatCombinator).flatMap(Function.identity());
        }
    }

    public static class Combinator7<T1, T2, T3, T4, T5, T6, T7> {
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final Arbitrary<T6> a6;
        private final Arbitrary<T7> a7;

        private Combinator7(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7) {
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.a6 = a6;
            this.a7 = a7;
        }

        public <R> Arbitrary<R> as(F7<T1, T2, T3, T4, T5, T6, T7, @NotNull R> combinator) {
            return CombinatorsFacade.implementation.combine(Combinators.combineFunction(combinator), this.a1, this.a2, this.a3, this.a4, this.a5, this.a6, this.a7);
        }

        public <R> Arbitrary<R> flatAs(F7<T1, T2, T3, T4, T5, T6, T7, Arbitrary<@NotNull R>> flatCombinator) {
            return this.as(flatCombinator).flatMap(Function.identity());
        }
    }

    public static class Combinator8<T1, T2, T3, T4, T5, T6, T7, T8> {
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final Arbitrary<T6> a6;
        private final Arbitrary<T7> a7;
        private final Arbitrary<T8> a8;

        private Combinator8(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7, Arbitrary<T8> a8) {
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.a6 = a6;
            this.a7 = a7;
            this.a8 = a8;
        }

        public <R> Arbitrary<R> as(F8<T1, T2, T3, T4, T5, T6, T7, T8, @NotNull R> combinator) {
            return CombinatorsFacade.implementation.combine(Combinators.combineFunction(combinator), this.a1, this.a2, this.a3, this.a4, this.a5, this.a6, this.a7, this.a8);
        }

        public <R> Arbitrary<R> flatAs(F8<T1, T2, T3, T4, T5, T6, T7, T8, Arbitrary<@NotNull R>> flatCombinator) {
            return this.as(flatCombinator).flatMap(Function.identity());
        }
    }

    public static class ListCombinator<T> {
        private final List<Arbitrary<T>> listOfArbitraries;

        private ListCombinator(List<Arbitrary<T>> listOfArbitraries) {
            this.listOfArbitraries = listOfArbitraries;
        }

        public <R> Arbitrary<R> as(Function<List<T>, @NotNull R> combinator) {
            Arbitrary[] arbitraries = this.listOfArbitraries.toArray(new Arbitrary[this.listOfArbitraries.size()]);
            Function<List, Object> combineFunction = params -> combinator.apply((List)params);
            return CombinatorsFacade.implementation.combine(combineFunction, arbitraries);
        }

        public <R> Arbitrary<R> flatAs(Function<List<T>, Arbitrary<@NotNull R>> flatCombinator) {
            return this.as(flatCombinator).flatMap(Function.identity());
        }
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class CombinatorsFacade {
        private static final CombinatorsFacade implementation = FacadeLoader.load(CombinatorsFacade.class);

        public abstract <R> Arbitrary<R> combine(Function<List<Object>, R> var1, Arbitrary<?> ... var2);
    }
}

