/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.state;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.state.Action;
import net.jqwik.api.state.Transformer;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;

@API(status=API.Status.EXPERIMENTAL, since="1.7.0")
public class ActionBuilder<S> {
    private final Predicate<S> precondition;
    private final String description;

    ActionBuilder() {
        this(null, null);
    }

    private ActionBuilder(Predicate<S> precondition, String description) {
        this.precondition = precondition;
        this.description = description;
    }

    public ActionBuilder<S> when(Predicate<S> precondition) {
        return new ActionBuilder<S>(precondition, this.description);
    }

    public ActionBuilder<S> describeAs(String description) {
        return new ActionBuilder<S>(this.precondition, description);
    }

    public Action.Independent<S> just(final Transformer<S> transformer) {
        if (this.precondition == null) {
            return () -> this.justTransformer(transformer);
        }
        return new Action.Independent<S>(){

            @Override
            public Arbitrary<Transformer<S>> transformer() {
                return ActionBuilder.this.justTransformer(transformer);
            }

            @Override
            public boolean precondition(S state) {
                return ActionBuilder.this.precondition.test(state);
            }
        };
    }

    @NotNull
    private Arbitrary<Transformer<S>> justTransformer(Transformer<S> transformer) {
        Transformer<S> withDescription = this.description == null ? transformer : Transformer.transform(this.description, transformer);
        return Arbitraries.just(withDescription);
    }

    public Action.Independent<S> justMutate(Consumer<S> mutatingFunction) {
        Transformer transformer = state -> {
            mutatingFunction.accept(state);
            return state;
        };
        return this.just(transformer);
    }
}

