/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.support.ModifierSupport;

@API(status=API.Status.INTERNAL)
public class LambdaSupport {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final ClassValue<List<FieldAccessor>> FIELD_ACCESSORS = new ClassValue<List<FieldAccessor>>(){

        @Override
        protected @Nullable List<FieldAccessor> computeValue(Class<?> type) {
            Field[] fields = type.getDeclaredFields();
            ArrayList<FieldAccessor> res = new ArrayList<FieldAccessor>(fields.length);
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    res.add(new FieldAccessor(LambdaSupport.isFunctionalType(field.getType()), LOOKUP.unreflectGetter(field)));
                }
            }
            catch (Throwable e) {
                return null;
            }
            return res;
        }
    };

    private LambdaSupport() {
    }

    public static <T> boolean areEqual(T l1, T l2) {
        List<FieldAccessor> accessors;
        if (l1 == l2) {
            return true;
        }
        if (l1.equals(l2)) {
            return true;
        }
        Class<?> l1Class = l1.getClass();
        if (l1Class != l2.getClass()) {
            return false;
        }
        if (l1 instanceof Serializable) {
            try {
                return Arrays.equals(LambdaSupport.serialize(l1), LambdaSupport.serialize(l2));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((accessors = FIELD_ACCESSORS.get(l1Class)) == null) {
            return false;
        }
        for (FieldAccessor accessor : accessors) {
            if (LambdaSupport.fieldIsEqualIn(accessor, l1, l2)) continue;
            return false;
        }
        return true;
    }

    private static <T> byte[] serialize(T l1) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
        outputStream.writeObject(l1);
        return byteArrayOutputStream.toByteArray();
    }

    private static boolean fieldIsEqualIn(FieldAccessor field, Object left, Object right) {
        try {
            MethodHandle handle = field.handle;
            if (field.isFunctionalType) {
                return LambdaSupport.areEqual(handle.invoke(left), handle.invoke(right));
            }
            return handle.invoke(left).equals(handle.invoke(right));
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean isFunctionalType(Class<?> candidateType) {
        if (!candidateType.isInterface()) {
            return false;
        }
        return LambdaSupport.countInterfaceMethods(candidateType) == 1L;
    }

    private static long countInterfaceMethods(Class<?> candidateType) {
        Method[] methods = candidateType.getMethods();
        return LambdaSupport.findInterfaceMethods(methods).size();
    }

    private static List<Method> findInterfaceMethods(Method[] methods) {
        return Arrays.stream(methods).filter(m -> !m.isDefault() && !ModifierSupport.isStatic((Member)m)).collect(Collectors.toList());
    }

    private static class FieldAccessor {
        final boolean isFunctionalType;
        final MethodHandle handle;

        FieldAccessor(boolean isFunctionalType, MethodHandle handle) {
            this.isFunctionalType = isFunctionalType;
            this.handle = handle;
        }
    }
}

