/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.providers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.FacadeLoader;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.0")
public interface TypeUsage {
    @API(status=API.Status.INTERNAL)
    public static final TypeUsage OBJECT_TYPE = TypeUsage.of(Object.class, new TypeUsage[0]);

    public static TypeUsage of(Class<?> type, TypeUsage ... typeParameters) {
        return TypeUsageFacade.implementation.of(type, typeParameters);
    }

    public static TypeUsage wildcard(TypeUsage upperBound) {
        return TypeUsageFacade.implementation.wildcardOf(upperBound);
    }

    public static TypeUsage forType(Type type) {
        return TypeUsageFacade.implementation.forType(type);
    }

    public Class<?> getRawType();

    public List<TypeUsage> getUpperBounds();

    public List<TypeUsage> getLowerBounds();

    public boolean isWildcard();

    public boolean isTypeVariable();

    public boolean isTypeVariableOrWildcard();

    public List<TypeUsage> getTypeArguments();

    public TypeUsage getTypeArgument(int var1);

    public boolean isOfType(Class<?> var1);

    public boolean canBeAssignedTo(TypeUsage var1);

    public boolean isGeneric();

    public boolean isEnum();

    public boolean isArray();

    public List<Annotation> getAnnotations();

    public <A extends Annotation> Optional<A> findAnnotation(Class<A> var1);

    public <A extends Annotation> boolean isAnnotated(Class<A> var1);

    public boolean isAssignableFrom(Class<?> var1);

    public Optional<TypeUsage> getComponentType();

    @API(status=API.Status.EXPERIMENTAL, since="1.2.0")
    public boolean isVoid();

    @API(status=API.Status.EXPERIMENTAL, since="1.2.0")
    public Optional<TypeUsage> getSuperclass();

    @API(status=API.Status.EXPERIMENTAL, since="1.8.0")
    public List<TypeUsage> getSuperTypes();

    @API(status=API.Status.EXPERIMENTAL, since="1.2.0")
    public List<TypeUsage> getInterfaces();

    @API(status=API.Status.INTERNAL, since="1.2.0")
    public Type getType();

    @API(status=API.Status.INTERNAL, since="1.2.0")
    public AnnotatedType getAnnotatedType();

    @API(status=API.Status.EXPERIMENTAL, since="1.6.0")
    public boolean isNullable();

    @API(status=API.Status.EXPERIMENTAL, since="1.8.0")
    public boolean isParameterizedRaw();

    @API(status=API.Status.EXPERIMENTAL, since="1.8.0")
    public boolean isSuperWildcard();

    @API(status=API.Status.EXPERIMENTAL, since="1.8.0")
    public boolean isExtendsConstraint();

    @API(status=API.Status.EXPERIMENTAL, since="1.6.0")
    public TypeUsage asNullable();

    @API(status=API.Status.EXPERIMENTAL, since="1.6.0")
    public TypeUsage asNotNullable();

    @API(status=API.Status.EXPERIMENTAL, since="1.6.0")
    public String getTypeVariable();

    @API(status=API.Status.EXPERIMENTAL, since="1.6.0")
    public <A extends Annotation> TypeUsage withAnnotation(A var1);

    @API(status=API.Status.EXPERIMENTAL, since="1.6.0")
    public Optional<Object> getMetaInfo(String var1);

    @API(status=API.Status.EXPERIMENTAL, since="1.6.0")
    public TypeUsage withMetaInfo(String var1, Object var2);

    @API(status=API.Status.INTERNAL)
    public static abstract class TypeUsageFacade {
        private static final TypeUsageFacade implementation = FacadeLoader.load(TypeUsageFacade.class);

        public abstract TypeUsage of(Class<?> var1, TypeUsage ... var2);

        public abstract TypeUsage wildcardOf(TypeUsage var1);

        public abstract TypeUsage forType(Type var1);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.6.0")
    public static interface Enhancer {
        default public TypeUsage forParameter(TypeUsage original, Parameter parameter) {
            return original;
        }
    }
}

