/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.state;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.state.Transformer;
import org.apiguardian.api.API;

@FunctionalInterface
@API(status=API.Status.EXPERIMENTAL, since="1.7.0")
public interface Transformation<T>
extends Function<Supplier<T>, Arbitrary<Transformer<T>>> {
    public static final Predicate<?> NO_PRECONDITION = ignore -> false;

    public static <T> Builder<T> when(Predicate<T> precondition) {
        return new Builder(precondition);
    }

    default public Predicate<T> precondition() {
        return NO_PRECONDITION;
    }

    public static class Builder<T> {
        private final Predicate<T> precondition;

        private Builder(Predicate<T> precondition) {
            this.precondition = precondition;
        }

        public Transformation<T> provide(final Arbitrary<Transformer<T>> arbitrary) {
            return new Transformation<T>(){

                @Override
                public Predicate<T> precondition() {
                    return precondition;
                }

                @Override
                public Arbitrary<Transformer<T>> apply(Supplier<T> ignore) {
                    return arbitrary;
                }
            };
        }

        public Transformation<T> provide(final Function<T, Arbitrary<Transformer<T>>> arbitraryCreator) {
            return new Transformation<T>(){

                @Override
                public Predicate<T> precondition() {
                    return precondition;
                }

                @Override
                public Arbitrary<Transformer<T>> apply(Supplier<T> supplier) {
                    return (Arbitrary)arbitraryCreator.apply(supplier.get());
                }
            };
        }
    }
}

