package net.jqwik.api.arbitraries;

import java.util.*;

import org.apiguardian.api.*;

import net.jqwik.api.*;

import org.jspecify.annotations.*;

import static org.apiguardian.api.API.Status.*;

/**
 * Use this superclass if you want to provide a specialized type of arbitrary,
 * e.g. with additional methods for configuration or defaults,
 * but don't want to implement the whole {@linkplain Arbitrary} interface yourself.
 *
 * @param <T> The type of object to be generated by this arbitrary
 *
 * @see Arbitrary
 * @see Arbitraries
 */
@API(status = MAINTAINED, since = "1.4.0")
public abstract class ArbitraryDecorator<T>  implements Cloneable, Arbitrary<T> {

	private @Nullable Arbitrary<T> instance = null;

	/**
	 * Implement by calling jqwik's standard DSL for building arbitraries.
	 *
	 * @return a new arbitrary instance
	 */
	abstract protected Arbitrary<T> arbitrary();

	private Arbitrary<T> instance() {
		if (instance == null) {
			instance = arbitrary();
		}
		return instance;
	}

	@Override
	public RandomGenerator<T> generator(int genSize) {
		return instance().generator(genSize);
	}

	@Override
	public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
		return instance().generatorWithEmbeddedEdgeCases(genSize);
	}

	@Override
	public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
		return instance().exhaustive(maxNumberOfSamples);
	}

	@Override
	public boolean isGeneratorMemoizable() {
		return instance().isGeneratorMemoizable();
	}

	@Override
	public EdgeCases<T> edgeCases(int maxEdgeCases) {
		return instance().edgeCases(maxEdgeCases);
	}

	@Override
	public String toString() {
		return String.format("Decorated:%s", super.toString());
	}

	/**
	 * Use to clone current instance with its interface type
	 *
	 * @param <A> The special interface type of this arbitrary
	 * @return A cloned instance of this arbitrary
	 */
	@SuppressWarnings("unchecked")
	protected <A extends Arbitrary<?>> A typedClone() {
		try {
			return (A) this.clone();
		} catch (CloneNotSupportedException e) {
			throw new JqwikException(e.getMessage());
		}
	}

}
