/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.state;

import java.util.function.Consumer;
import java.util.function.Function;
import org.apiguardian.api.API;

@FunctionalInterface
@API(status=API.Status.EXPERIMENTAL, since="1.7.0")
public interface Transformer<T>
extends Function<T, T> {
    public static final Transformer<?> END_OF_CHAIN = new Transformer<Object>(){

        @Override
        public Object apply(Object t) {
            return t;
        }

        @Override
        public String transformation() {
            return "End of Chain";
        }

        @Override
        public boolean isEndOfChain() {
            return true;
        }

        public String toString() {
            return this.transformation();
        }
    };
    public static final Transformer<?> NOOP = new Transformer<Object>(){

        @Override
        public Object apply(Object t) {
            return t;
        }

        @Override
        public String transformation() {
            return "noop";
        }

        @Override
        public boolean isEndOfChain() {
            return false;
        }

        public String toString() {
            return this.transformation();
        }
    };

    public static <T> Transformer<T> endOfChain() {
        return END_OF_CHAIN;
    }

    public static <T> Transformer<T> noop() {
        return NOOP;
    }

    public static <S> Transformer<S> transform(final String description, final Function<? super S, ? extends S> transform) {
        return new Transformer<S>(){

            @Override
            public S apply(S s) {
                return transform.apply(s);
            }

            @Override
            public String transformation() {
                return description;
            }
        };
    }

    public static <S> Transformer<S> mutate(String description, Consumer<? super S> mutate) {
        Function<Object, Object> transformer = s -> {
            mutate.accept((Object)s);
            return s;
        };
        return Transformer.transform(description, transformer);
    }

    default public String transformation() {
        return this.toString();
    }

    default public boolean isEndOfChain() {
        return false;
    }
}

