/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.SampleReportingFormat;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.3.10")
public abstract class JavaBeanReportingFormat
implements SampleReportingFormat {
    protected abstract Collection<Class<?>> beanTypes();

    protected Collection<String> excludeProperties() {
        return Collections.emptySet();
    }

    protected List<String> sortProperties(List<String> properties) {
        return properties;
    }

    protected boolean reportNulls() {
        return false;
    }

    @Override
    public Optional<String> label(Object value) {
        return Optional.of(value.getClass().getSimpleName());
    }

    @Override
    public boolean appliesTo(Object value) {
        if (value == null) {
            return false;
        }
        return this.beanTypes().stream().anyMatch(beanType -> beanType.isAssignableFrom(value.getClass()));
    }

    @Override
    public final Object report(Object value) {
        return JavaBeanReportingFormatFacade.implementation.reportJavaBean(value, this.reportNulls(), this.excludeProperties(), this::sortProperties);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class JavaBeanReportingFormatFacade {
        private static final JavaBeanReportingFormatFacade implementation = FacadeLoader.load(JavaBeanReportingFormatFacade.class);

        public abstract Object reportJavaBean(Object var1, boolean var2, Collection<String> var3, Function<List<String>, List<String>> var4);
    }
}

