/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.ShrinkingDistance;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public interface Shrinkable<T>
extends Comparable<Shrinkable<T>> {
    public static <T> Shrinkable<T> unshrinkable(T value) {
        return Shrinkable.unshrinkable(value, ShrinkingDistance.MIN);
    }

    public static <T> Shrinkable<T> unshrinkable(T value, ShrinkingDistance distance) {
        return ShrinkableFacade.implementation.unshrinkable(() -> value, distance);
    }

    @API(status=API.Status.INTERNAL)
    public static <T> Shrinkable<T> supplyUnshrinkable(Supplier<? extends T> supplier) {
        return ShrinkableFacade.implementation.unshrinkable(supplier, ShrinkingDistance.MIN);
    }

    public T value();

    @API(status=API.Status.INTERNAL, since="1.3.3")
    public Stream<Shrinkable<T>> shrink();

    @API(status=API.Status.INTERNAL, since="1.3.3")
    default public Optional<Shrinkable<T>> grow(Shrinkable<?> before, Shrinkable<?> after) {
        return Optional.empty();
    }

    @API(status=API.Status.INTERNAL, since="1.3.3")
    default public Stream<Shrinkable<T>> grow() {
        return Stream.empty();
    }

    public ShrinkingDistance distance();

    @API(status=API.Status.INTERNAL, since="1.2.4")
    default public Shrinkable<Object> asGeneric() {
        return this;
    }

    default public <U> Shrinkable<U> map(Function<? super T, ? extends U> mapper) {
        return ShrinkableFacade.implementation.map(this, mapper);
    }

    default public Shrinkable<T> filter(Predicate<? super T> filter) {
        return ShrinkableFacade.implementation.filter(this, filter);
    }

    default public <U> Shrinkable<U> flatMap(Function<? super T, ? extends Arbitrary<U>> flatMapper, int tries, long randomSeed) {
        return ShrinkableFacade.implementation.flatMap(this, flatMapper, tries, randomSeed);
    }

    @Override
    @API(status=API.Status.INTERNAL)
    default public int compareTo(Shrinkable<T> other) {
        T value;
        int comparison = this.distance().compareTo(other.distance());
        if (comparison == 0 && (value = this.value()) instanceof Comparable && this.getClass().equals(other.getClass())) {
            return ((Comparable)value).compareTo(other.value());
        }
        return comparison;
    }

    @API(status=API.Status.INTERNAL)
    default public Shrinkable<T> makeUnshrinkable() {
        return ShrinkableFacade.implementation.unshrinkable(this::value, this.distance());
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ShrinkableFacade {
        private static final ShrinkableFacade implementation = FacadeLoader.load(ShrinkableFacade.class);

        public abstract <T> Shrinkable<T> unshrinkable(Supplier<? extends T> var1, ShrinkingDistance var2);

        public abstract <T, U> Shrinkable<U> map(Shrinkable<T> var1, Function<? super T, ? extends U> var2);

        public abstract <T> Shrinkable<T> filter(Shrinkable<T> var1, Predicate<? super T> var2);

        public abstract <T, U> Shrinkable<U> flatMap(Shrinkable<T> var1, Function<? super T, ? extends Arbitrary<U>> var2, int var3, long var4);
    }
}

