/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import net.jqwik.engine.PropertyDefaultValues;
import net.jqwik.engine.discovery.ElementResolver;
import net.jqwik.engine.discovery.GroupContainerResolver;
import net.jqwik.engine.discovery.HierarchicalJavaResolver;
import net.jqwik.engine.discovery.PropertyMethodResolver;
import net.jqwik.engine.discovery.TopLevelContainerResolver;
import net.jqwik.engine.discovery.predicates.IsScannableContainerClass;
import net.jqwik.engine.recording.TestRunData;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;

public class JqwikDiscoverer {
    private static final IsScannableContainerClass isScannableTestClass = new IsScannableContainerClass();
    private final TestRunData testRunData;
    private final PropertyDefaultValues propertyDefaultValues;

    public JqwikDiscoverer(TestRunData testRunData, PropertyDefaultValues propertyDefaultValues) {
        this.testRunData = testRunData;
        this.propertyDefaultValues = propertyDefaultValues;
    }

    public void discover(EngineDiscoveryRequest request, TestDescriptor engineDescriptor) {
        HierarchicalJavaResolver javaElementsResolver = this.createHierarchicalResolver(engineDescriptor);
        Predicate<String> classNamePredicate = JqwikDiscoverer.buildClassNamePredicate(request);
        request.getSelectorsByType(ModuleSelector.class).forEach(selector -> ReflectionSupport.findAllClassesInModule((String)selector.getModuleName(), (Predicate)isScannableTestClass, (Predicate)classNamePredicate).forEach(javaElementsResolver::resolveClass));
        request.getSelectorsByType(ClasspathRootSelector.class).forEach(selector -> ReflectionSupport.findAllClassesInClasspathRoot((URI)selector.getClasspathRoot(), (Predicate)isScannableTestClass, (Predicate)classNamePredicate).forEach(javaElementsResolver::resolveClass));
        request.getSelectorsByType(PackageSelector.class).forEach(selector -> ReflectionSupport.findAllClassesInPackage((String)selector.getPackageName(), (Predicate)isScannableTestClass, (Predicate)classNamePredicate).forEach(javaElementsResolver::resolveClass));
        request.getSelectorsByType(ClassSelector.class).forEach(selector -> javaElementsResolver.resolveClass(selector.getJavaClass()));
        request.getSelectorsByType(MethodSelector.class).forEach(selector -> javaElementsResolver.resolveMethod(selector.getJavaClass(), selector.getJavaMethod()));
        request.getSelectorsByType(UniqueIdSelector.class).forEach(selector -> javaElementsResolver.resolveUniqueId(selector.getUniqueId()));
    }

    private HierarchicalJavaResolver createHierarchicalResolver(TestDescriptor engineDescriptor) {
        HashSet<ElementResolver> resolvers = new HashSet<ElementResolver>();
        resolvers.add(new TopLevelContainerResolver());
        resolvers.add(new GroupContainerResolver());
        resolvers.add(new PropertyMethodResolver(this.testRunData, this.propertyDefaultValues));
        return new HierarchicalJavaResolver(engineDescriptor, resolvers);
    }

    private static Predicate<String> buildClassNamePredicate(EngineDiscoveryRequest request) {
        ArrayList filters = new ArrayList();
        filters.addAll(request.getFiltersByType(ClassNameFilter.class));
        filters.addAll(request.getFiltersByType(PackageNameFilter.class));
        return Filter.composeFilters(filters).toPredicate();
    }
}

