/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.ForAll;
import net.jqwik.api.Tuple;
import net.jqwik.engine.descriptor.PropertyConfiguration;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.CachingArbitraryResolver;
import net.jqwik.engine.execution.CheckedProperty;
import net.jqwik.engine.facades.DomainContextFacadeImpl;
import net.jqwik.engine.properties.CheckedFunction;
import net.jqwik.engine.properties.PropertyMethodArbitraryResolver;
import net.jqwik.engine.properties.PropertyMethodDataResolver;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.MethodParameter;
import org.junit.platform.commons.support.ReflectionSupport;

public class CheckedPropertyFactory {
    private static List<Class<?>> BOOLEAN_RETURN_TYPES = Arrays.asList(Boolean.TYPE, Boolean.class);

    public CheckedProperty fromDescriptor(PropertyMethodDescriptor propertyMethodDescriptor, Object testInstance) {
        String displayName = propertyMethodDescriptor.getDisplayName();
        String propertyName = propertyMethodDescriptor.getParent().map(parent -> parent.getDisplayName() + ":" + displayName).orElse(displayName);
        Method propertyMethod = propertyMethodDescriptor.getTargetMethod();
        PropertyConfiguration configuration = propertyMethodDescriptor.getConfiguration();
        CheckedFunction checkedFunction = this.createCheckedFunction(propertyMethodDescriptor, testInstance);
        List<MethodParameter> forAllParameters = this.extractForAllParameters(propertyMethod, propertyMethodDescriptor.getContainerClass());
        PropertyMethodArbitraryResolver arbitraryResolver = new PropertyMethodArbitraryResolver(propertyMethodDescriptor.getContainerClass(), testInstance, DomainContextFacadeImpl.currentContext.get());
        Optional<Iterable<? extends Tuple>> optionalData = new PropertyMethodDataResolver(propertyMethodDescriptor.getContainerClass(), testInstance).forMethod(propertyMethodDescriptor.getTargetMethod());
        return new CheckedProperty(propertyName, checkedFunction, forAllParameters, new CachingArbitraryResolver(arbitraryResolver), optionalData, configuration);
    }

    private CheckedFunction createCheckedFunction(PropertyMethodDescriptor propertyMethodDescriptor, Object testInstance) {
        Class<?> returnType = propertyMethodDescriptor.getTargetMethod().getReturnType();
        Function<List, Object> function = params -> ReflectionSupport.invokeMethod((Method)propertyMethodDescriptor.getTargetMethod(), (Object)testInstance, (Object[])params.toArray());
        if (BOOLEAN_RETURN_TYPES.contains(returnType)) {
            return params -> (Boolean)function.apply((List)params);
        }
        return params -> {
            function.apply((List)params);
            return true;
        };
    }

    private List<MethodParameter> extractForAllParameters(Method targetMethod, Class<?> containerClass) {
        return Arrays.stream(JqwikReflectionSupport.getMethodParameters(targetMethod, containerClass)).filter(this::isForAllPresent).collect(Collectors.toList());
    }

    private boolean isForAllPresent(MethodParameter parameter) {
        return parameter.isAnnotated(ForAll.class);
    }
}

