/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.Set;
import java.util.logging.Logger;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.descriptor.JqwikEngineDescriptor;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.descriptor.SkipExecutionDecorator;
import net.jqwik.engine.execution.ContainerTaskCreator;
import net.jqwik.engine.execution.ExecutionTaskCreator;
import net.jqwik.engine.execution.PropertyTaskCreator;
import net.jqwik.engine.execution.RecordingExecutionListener;
import net.jqwik.engine.execution.lifecycle.LifecycleRegistry;
import net.jqwik.engine.execution.pipeline.ExecutionPipeline;
import net.jqwik.engine.execution.pipeline.ExecutionTask;
import net.jqwik.engine.execution.pipeline.Pipeline;
import net.jqwik.engine.recording.TestRunRecorder;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

public class JqwikExecutor {
    private final LifecycleRegistry registry;
    private final TestRunRecorder recorder;
    private final Set<UniqueId> previousFailedTests;
    private final boolean useJunitPlatformReporter;
    private final boolean reportOnlyFailures;
    private final PropertyTaskCreator propertyTaskCreator = new PropertyTaskCreator();
    private final ContainerTaskCreator containerTaskCreator = new ContainerTaskCreator();
    private final ExecutionTaskCreator childTaskCreator = this::createTask;
    private static final Logger LOG = Logger.getLogger(JqwikExecutor.class.getName());

    public JqwikExecutor(LifecycleRegistry registry, TestRunRecorder recorder, Set<UniqueId> previousFailedTests, boolean useJunitPlatformReporter, boolean reportOnlyFailures) {
        this.registry = registry;
        this.recorder = recorder;
        this.previousFailedTests = previousFailedTests;
        this.useJunitPlatformReporter = useJunitPlatformReporter;
        this.reportOnlyFailures = reportOnlyFailures;
    }

    public void execute(TestDescriptor descriptor, EngineExecutionListener engineExecutionListener) {
        RecordingExecutionListener recordingListener = new RecordingExecutionListener(this.recorder, engineExecutionListener, this.useJunitPlatformReporter);
        ExecutionPipeline pipeline = new ExecutionPipeline(recordingListener);
        ExecutionTask mainTask = this.createTask(descriptor, pipeline);
        pipeline.submit(mainTask, new ExecutionTask[0]);
        this.letNonSuccessfulTestsExecuteFirst(pipeline);
        pipeline.runToTermination();
    }

    private void letNonSuccessfulTestsExecuteFirst(ExecutionPipeline pipeline) {
        this.previousFailedTests.forEach(pipeline::executeFirst);
    }

    private ExecutionTask createTask(TestDescriptor descriptor, Pipeline pipeline) {
        if (descriptor.getClass().equals(JqwikEngineDescriptor.class)) {
            return this.createContainerTask(descriptor, pipeline);
        }
        if (descriptor.getClass().equals(ContainerClassDescriptor.class)) {
            return this.createContainerTask(descriptor, pipeline);
        }
        if (descriptor.getClass().equals(PropertyMethodDescriptor.class)) {
            return this.createPropertyTask((PropertyMethodDescriptor)descriptor, pipeline);
        }
        if (descriptor.getClass().equals(SkipExecutionDecorator.class)) {
            return this.createSkippingTask((SkipExecutionDecorator)descriptor, pipeline);
        }
        return ExecutionTask.from(listener -> LOG.warning(() -> String.format("Cannot execute descriptor [%s]", descriptor)), descriptor.getUniqueId(), "log warning");
    }

    private ExecutionTask createSkippingTask(SkipExecutionDecorator descriptor, Pipeline pipeline) {
        String taskDescription = String.format("Skipping [%s] due to: %s", descriptor.getDisplayName(), descriptor.getSkippingReason());
        return ExecutionTask.from(listener -> listener.executionSkipped(descriptor, descriptor.getSkippingReason()), descriptor.getUniqueId(), taskDescription);
    }

    private ExecutionTask createPropertyTask(PropertyMethodDescriptor propertyMethodDescriptor, Pipeline pipeline) {
        return this.propertyTaskCreator.createTask(propertyMethodDescriptor, this.registry, this.reportOnlyFailures);
    }

    private ExecutionTask createContainerTask(TestDescriptor containerDescriptor, Pipeline pipeline) {
        return this.containerTaskCreator.createTask(containerDescriptor, this.childTaskCreator, pipeline, this.registry);
    }
}

