/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.ForAll;
import net.jqwik.api.JqwikException;
import net.jqwik.api.domains.Domain;
import net.jqwik.api.domains.DomainContext;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.CheckedProperty;
import net.jqwik.engine.execution.CheckedPropertyFactory;
import net.jqwik.engine.execution.CombinedDomainContext;
import net.jqwik.engine.execution.PropertyExecutionListener;
import net.jqwik.engine.execution.lifecycle.LifecycleSupplier;
import net.jqwik.engine.facades.DomainContextFacadeImpl;
import net.jqwik.engine.properties.PropertyCheckResult;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.engine.reporting.ReportEntry;
import org.opentest4j.TestAbortedException;

public class PropertyMethodExecutor {
    private static final Logger LOG = Logger.getLogger(PropertyMethodExecutor.class.getName());
    private final PropertyMethodDescriptor methodDescriptor;
    private final PropertyLifecycleContext propertyLifecycleContext;
    private final boolean reportOnlyFailures;
    private CheckedPropertyFactory checkedPropertyFactory = new CheckedPropertyFactory();

    public PropertyMethodExecutor(PropertyMethodDescriptor methodDescriptor, PropertyLifecycleContext propertyLifecycleContext, boolean reportOnlyFailures) {
        this.methodDescriptor = methodDescriptor;
        this.propertyLifecycleContext = propertyLifecycleContext;
        this.reportOnlyFailures = reportOnlyFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyExecutionResult execute(LifecycleSupplier lifecycleSupplier, PropertyExecutionListener listener) {
        try {
            DomainContext domainContext = this.combineDomainContexts(this.methodDescriptor.getDomains());
            DomainContextFacadeImpl.currentContext.set(domainContext);
            PropertyExecutionResult propertyExecutionResult = this.executePropertyMethod(lifecycleSupplier, listener);
            return propertyExecutionResult;
        }
        finally {
            DomainContextFacadeImpl.currentContext.remove();
        }
    }

    private void ensureAllParametersHaveForAll(PropertyMethodDescriptor methodDescriptor) {
        String parameters = Arrays.stream(methodDescriptor.getTargetMethod().getParameters()).filter(parameter -> !parameter.isAnnotationPresent(ForAll.class)).map(parameter -> parameter.toString()).collect(Collectors.joining(", "));
        if (!parameters.isEmpty()) {
            String message = String.format("All parameters must have @ForAll annotation: %s", parameters);
            throw new JqwikException(message);
        }
    }

    private DomainContext combineDomainContexts(Set<Domain> domainAnnotations) {
        if (domainAnnotations.isEmpty()) {
            return DomainContext.global();
        }
        Set<DomainContext> domainContexts = domainAnnotations.stream().map(this::createDomainContext).collect(Collectors.toSet());
        return new CombinedDomainContext(domainContexts);
    }

    private DomainContext createDomainContext(Domain domain) {
        Class domainContextClass = domain.value();
        try {
            DomainContext domainContext = (DomainContext)JqwikReflectionSupport.newInstanceInTestContext(domainContextClass, this.propertyLifecycleContext.testInstance());
            if (domain.priority() != Integer.MIN_VALUE) {
                domainContext.setDefaultPriority(domain.priority());
            }
            return domainContext;
        }
        catch (Throwable throwable) {
            String message = String.format("Cannot instantiate domain context @Domain(\"%s\") on [%s].", domainContextClass, this.methodDescriptor.getTargetMethod());
            throw new JqwikException(message);
        }
    }

    private PropertyExecutionResult executePropertyMethod(LifecycleSupplier lifecycleSupplier, PropertyExecutionListener listener) {
        PropertyExecutionResult propertyExecutionResult = PropertyExecutionResult.successful((String)this.methodDescriptor.getConfiguration().getSeed());
        AroundPropertyHook around = lifecycleSupplier.aroundPropertyHook(this.methodDescriptor);
        try {
            this.ensureAllParametersHaveForAll(this.methodDescriptor);
            propertyExecutionResult = around.aroundProperty(this.propertyLifecycleContext, () -> this.executeMethod(this.propertyLifecycleContext.testInstance(), listener));
        }
        catch (Throwable throwable) {
            if (propertyExecutionResult.getStatus() == PropertyExecutionResult.Status.SUCCESSFUL) {
                return PropertyExecutionResult.failed((Throwable)throwable, (String)propertyExecutionResult.getSeed().orElse(null), (List)propertyExecutionResult.getFalsifiedSample().orElse(null));
            }
            LOG.warning(throwable.toString());
            return propertyExecutionResult;
        }
        return propertyExecutionResult;
    }

    private PropertyExecutionResult executeMethod(Object testInstance, PropertyExecutionListener listener) {
        try {
            Consumer<ReportEntry> reporter = entry -> listener.reportingEntryPublished(this.methodDescriptor, (ReportEntry)entry);
            PropertyCheckResult checkResult = this.executeProperty(testInstance, reporter);
            return checkResult.toExecutionResult();
        }
        catch (TestAbortedException e) {
            return PropertyExecutionResult.aborted((Throwable)e, (String)this.methodDescriptor.getConfiguration().getSeed());
        }
        catch (Throwable t) {
            JqwikExceptionSupport.rethrowIfBlacklisted(t);
            return PropertyExecutionResult.failed((Throwable)t, (String)this.methodDescriptor.getConfiguration().getSeed(), null);
        }
    }

    private PropertyCheckResult executeProperty(Object testInstance, Consumer<ReportEntry> publisher) {
        CheckedProperty property = this.checkedPropertyFactory.fromDescriptor(this.methodDescriptor, testInstance);
        return property.check(publisher, this.methodDescriptor.getReporting(), this.reportOnlyFailures);
    }
}

