/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.LifecycleHook;
import net.jqwik.api.lifecycle.SkipExecutionHook;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.lifecycle.LifecycleSupplier;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.TestDescriptor;

public class LifecycleRegistry
implements LifecycleSupplier {
    private final List<HookRegistration> registrations = new ArrayList<HookRegistration>();
    private final Map<Class<? extends LifecycleHook>, LifecycleHook> instances = new HashMap<Class<? extends LifecycleHook>, LifecycleHook>();

    @Override
    public AroundPropertyHook aroundPropertyHook(PropertyMethodDescriptor propertyMethodDescriptor) {
        List<AroundPropertyHook> aroundPropertyHooks = this.findHooks(propertyMethodDescriptor, AroundPropertyHook.class);
        return AroundPropertyHook.combine(aroundPropertyHooks);
    }

    @Override
    public SkipExecutionHook skipExecutionHook(TestDescriptor testDescriptor) {
        List<SkipExecutionHook> skipExecutionHooks = this.findHooks(testDescriptor, SkipExecutionHook.class);
        return SkipExecutionHook.combine(skipExecutionHooks);
    }

    private <T extends LifecycleHook> List<T> findHooks(TestDescriptor descriptor, Class<T> hookType) {
        List<Class<T>> hookClasses = this.findHookClasses(descriptor, hookType);
        return hookClasses.stream().map(hookClass -> this.instances.get(hookClass)).sorted().collect(Collectors.toList());
    }

    private <T extends LifecycleHook> List<Class<T>> findHookClasses(TestDescriptor descriptor, Class<T> hookType) {
        return this.registrations.stream().filter(registration -> registration.match(descriptor)).filter(registration -> registration.match(hookType)).map(registration -> ((HookRegistration)registration).hookClass).distinct().collect(Collectors.toList());
    }

    void registerLifecycleInstance(TestDescriptor descriptor, LifecycleHook hookInstance) {
        Class<?> hookClass = hookInstance.getClass();
        HookRegistration registration = new HookRegistration(descriptor, hookClass);
        if (this.registrations.contains(registration)) {
            return;
        }
        this.registrations.add(registration);
        if (!this.instances.containsKey(hookClass)) {
            this.instances.put(hookClass, hookInstance);
        }
    }

    public void registerLifecycleHook(TestDescriptor descriptor, Class<? extends LifecycleHook> hookClass, Function<String, Optional<String>> parameters) {
        if (JqwikReflectionSupport.isInnerClass(hookClass)) {
            String message = String.format("Inner class [%s] cannot be used as LifecycleHook", hookClass.getName());
            throw new JqwikException(message);
        }
        this.registrations.add(new HookRegistration(descriptor, hookClass));
        if (!this.instances.containsKey(hookClass)) {
            LifecycleHook hookInstance = (LifecycleHook)ReflectionSupport.newInstance(hookClass, (Object[])new Object[0]);
            hookInstance.configure(parameters);
            this.instances.put(hookClass, hookInstance);
        }
    }

    private static class HookRegistration {
        private TestDescriptor descriptor;
        private final Class<? extends LifecycleHook> hookClass;

        private HookRegistration(TestDescriptor descriptor, Class<? extends LifecycleHook> hookClass) {
            this.descriptor = descriptor;
            this.hookClass = hookClass;
        }

        public boolean match(TestDescriptor descriptor) {
            if (descriptor == null) {
                return false;
            }
            if (this.descriptor.equals(descriptor)) {
                return true;
            }
            return this.match((TestDescriptor)descriptor.getParent().orElse(null));
        }

        public <T extends LifecycleHook> boolean match(Class<? extends LifecycleHook> hookType) {
            return hookType.isAssignableFrom(this.hookClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HookRegistration that = (HookRegistration)o;
            if (!this.descriptor.equals(that.descriptor)) {
                return false;
            }
            return this.hookClass.equals(that.hookClass);
        }

        public int hashCode() {
            int result = this.descriptor.hashCode();
            result = 31 * result + this.hookClass.hashCode();
            return result;
        }
    }
}

