/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.arbitraries.SizableArbitrary;
import net.jqwik.engine.properties.arbitraries.ArbitrariesSupport;
import net.jqwik.engine.properties.arbitraries.ArrayArbitrary;
import net.jqwik.engine.properties.arbitraries.IteratorArbitrary;
import net.jqwik.engine.properties.arbitraries.ListArbitrary;
import net.jqwik.engine.properties.arbitraries.SetArbitrary;
import net.jqwik.engine.properties.arbitraries.StreamArbitrary;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;

public class ArbitraryFacadeImpl
extends Arbitrary.ArbitraryFacade {
    public <T, U> Optional<ExhaustiveGenerator<U>> flatMapExhaustiveGenerator(ExhaustiveGenerator<T> self, Function<T, Arbitrary<U>> mapper) {
        return ExhaustiveGenerators.flatMap(self, mapper);
    }

    public <T> SizableArbitrary<List<T>> list(Arbitrary<T> elementArbitrary) {
        return new ListArbitrary<T>(elementArbitrary);
    }

    public <T> SizableArbitrary<List<T>> listOfUnique(Arbitrary<T> uniqueArbitrary) {
        return new ListArbitrary<T>(uniqueArbitrary).ofMaxSize(ArbitrariesSupport.maxNumberOfElements(uniqueArbitrary, 255));
    }

    public <T> SizableArbitrary<Set<T>> set(Arbitrary<T> elementArbitrary) {
        return new SetArbitrary<T>(elementArbitrary).ofMaxSize(ArbitrariesSupport.maxNumberOfElements(elementArbitrary, 255));
    }

    public <T> SizableArbitrary<Stream<T>> stream(Arbitrary<T> elementArbitrary) {
        return new StreamArbitrary<T>(elementArbitrary);
    }

    public <T> SizableArbitrary<Iterator<T>> iterator(Arbitrary<T> elementArbitrary) {
        return new IteratorArbitrary<T>(elementArbitrary);
    }

    public <T, A> SizableArbitrary<A> array(Arbitrary<T> elementArbitrary, Class<A> arrayClass) {
        return new ArrayArbitrary<A, T>(elementArbitrary, arrayClass);
    }

    public <T, A> SizableArbitrary<A> arrayOfUnique(Arbitrary<T> uniqueArbitrary, Class<A> arrayClass) {
        return new ArrayArbitrary<A, T>(uniqueArbitrary, arrayClass).ofMaxSize(ArbitrariesSupport.maxNumberOfElements(uniqueArbitrary, 255));
    }
}

