/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jqwik.api.StatisticsCollector;
import org.junit.platform.engine.reporting.ReportEntry;

public class StatisticsCollectorImpl
implements StatisticsCollector {
    public static final String DEFAULT_LABEL = "statistics";
    private static ThreadLocal<Map<String, StatisticsCollectorImpl>> collectors = ThreadLocal.withInitial(LinkedHashMap::new);
    private final Map<List<Object>, Integer> counts = new HashMap<List<Object>, Integer>();
    private final String label;

    public static void clearAll() {
        collectors.remove();
    }

    public static StatisticsCollectorImpl get() {
        return StatisticsCollectorImpl.get(DEFAULT_LABEL);
    }

    public static StatisticsCollectorImpl get(String label) {
        Map<String, StatisticsCollectorImpl> collectors = StatisticsCollectorImpl.collectors.get();
        collectors.putIfAbsent(label, new StatisticsCollectorImpl(label));
        return collectors.get(label);
    }

    public static void report(Consumer<ReportEntry> reporter, String propertyName) {
        for (StatisticsCollectorImpl collector : collectors.get().values()) {
            reporter.accept(collector.createReportEntry(propertyName));
        }
    }

    public StatisticsCollectorImpl(String label) {
        this.label = label;
    }

    public void collect(Object ... values) {
        List key = Collections.emptyList();
        if (values != null) {
            key = Arrays.stream(values).filter(Objects::nonNull).collect(Collectors.toList());
        }
        int count = this.counts.computeIfAbsent(key, any -> 0);
        this.counts.put(key, ++count);
    }

    private boolean isEmpty() {
        return this.counts.isEmpty();
    }

    public Map<List<Object>, Integer> getCounts() {
        return this.counts;
    }

    public ReportEntry createReportEntry(String propertyName) {
        StringBuilder statistics = new StringBuilder();
        int sum = this.counts.values().stream().mapToInt(aCount -> aCount).sum();
        List statisticsEntries = this.counts.entrySet().stream().sorted(this::compareStatisticsEntries).filter(entry -> !((List)entry.getKey()).equals(Collections.emptyList())).map(entry -> new StatisticsEntry(this.displayKey((List)entry.getKey()), ((Integer)entry.getValue()).intValue(), (double)((Integer)entry.getValue()).intValue() * 100.0 / (double)sum)).collect(Collectors.toList());
        int maxKeyLength = statisticsEntries.stream().mapToInt(entry -> ((StatisticsEntry)entry).name.length()).max().orElse(0);
        boolean fullNumbersOnly = statisticsEntries.stream().noneMatch(entry -> ((StatisticsEntry)entry).percentage < 1.0);
        int decimals = (int)Math.round(Math.log10(sum));
        for (StatisticsEntry statsEntry : statisticsEntries) {
            statistics.append(this.formatEntry(statsEntry, maxKeyLength, fullNumbersOnly, decimals));
        }
        String keyStatistics = String.format("[%s] (%d) %s", propertyName, sum, this.label);
        return ReportEntry.from((String)keyStatistics, (String)statistics.toString());
    }

    private String formatEntry(StatisticsEntry statsEntry, int maxKeyLength, boolean fullNumbersOnly, int decimals) {
        return String.format("%n    %1$-" + maxKeyLength + "s (%2$" + decimals + "d) : %3$s %%", statsEntry.name, statsEntry.count, this.displayPercentage(statsEntry.percentage, fullNumbersOnly));
    }

    private int compareStatisticsEntries(Map.Entry<List<Object>, Integer> e1, Map.Entry<List<Object>, Integer> e2) {
        List<Object> k1 = e1.getKey();
        List<Object> k2 = e2.getKey();
        if (k1.size() != k2.size()) {
            return Integer.compare(k1.size(), k2.size());
        }
        return e2.getValue().compareTo(e1.getValue());
    }

    private String displayPercentage(double percentage, boolean fullNumbersOnly) {
        if (fullNumbersOnly) {
            return String.format("%2d", Math.round(percentage));
        }
        return String.format("%5.2f", (double)Math.round(percentage * 100.0) / 100.0);
    }

    private String displayKey(List<Object> key) {
        return key.stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    static class StatisticsEntry {
        private final String name;
        private long count;
        private final double percentage;

        StatisticsEntry(String name, long count, double percentage) {
            this.name = name;
            this.count = count;
            this.percentage = percentage;
        }
    }
}

